/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.config;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeRepositoryStoreImpl;
import com.atlassian.jirafisheyeplugin.config.properties.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraProjectKeyToIdConverter
implements Converter<Long> {
    private static final Logger log = LoggerFactory.getLogger(FishEyeRepositoryStoreImpl.class);
    private final ProjectManager projectManager;

    public JiraProjectKeyToIdConverter(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    @Override
    public String fromValue(Long jiraProjectId) {
        return String.valueOf(jiraProjectId);
    }

    @Override
    public Long toValue(String jiraProjectRef) {
        try {
            return Long.valueOf(jiraProjectRef);
        }
        catch (NumberFormatException e) {
            Project project = this.projectManager.getProjectObjByKey(jiraProjectRef);
            if (project != null) {
                return project.getId();
            }
            log.warn("Cannot convert '" + jiraProjectRef + "' to project id. Possibly project was removed.");
            return null;
        }
    }
}

