/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.commithook.restbeans;

import com.atlassian.jira.util.ErrorCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CommitHookErrors {
    @XmlElementWrapper(name="errors")
    @XmlElement(name="error")
    List<CommitHookError> errors = new ArrayList<CommitHookError>();

    public static CommitHookErrors fromSingleError(String command, String issueKey, String message) {
        CommitHookErrors e = new CommitHookErrors();
        e.addError(command, issueKey, message);
        return e;
    }

    public static CommitHookErrors fromErrorCollection(String command, String issueKey, ErrorCollection errors) {
        CommitHookErrors e = new CommitHookErrors();
        e.addErrors(command, issueKey, errors);
        return e;
    }

    public void addError(String command, String issueKey, String message) {
        this.errors.add(new CommitHookError(command, issueKey, message));
    }

    public void addErrors(CommitHookErrors other) {
        this.errors.addAll(other.errors);
    }

    public void addErrors(String command, String issueKey, ErrorCollection other) {
        for (Map.Entry entry : other.getErrors().entrySet()) {
            this.addError(command, issueKey, (String)entry.getKey() + ": " + (String)entry.getValue());
        }
        for (String string : other.getErrorMessages()) {
            this.addError(command, issueKey, string);
        }
    }

    public List<CommitHookError> getErrors() {
        return this.errors;
    }

    public boolean isEmpty() {
        return this.errors.isEmpty();
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class CommitHookError {
        String command;
        String issueKey;
        String message;

        public CommitHookError(String command, String issueKey, String message) {
            this.command = command;
            this.issueKey = issueKey;
            this.message = message;
        }

        public CommitHookError() {
        }

        public String getCommand() {
            return this.command;
        }

        public String getIssueKey() {
            return this.issueKey;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

