/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.commithook.handlers;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.worklog.WorklogInputParametersImpl;
import com.atlassian.jira.bc.issue.worklog.WorklogResult;
import com.atlassian.jira.bc.issue.worklog.WorklogService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jirafisheyeplugin.commithook.CommandType;
import com.atlassian.jirafisheyeplugin.commithook.handlers.CommandHandler;
import com.atlassian.jirafisheyeplugin.commithook.restbeans.CommitHookErrors;
import com.atlassian.jirafisheyeplugin.util.Either;
import java.util.Date;
import java.util.List;

public class WorkLogHandler
implements CommandHandler<Worklog> {
    private static CommandType CMD_TYPE = CommandType.LOG_WORK;
    private WorklogService worklogService;

    public WorkLogHandler(WorklogService worklogService) {
        this.worklogService = worklogService;
    }

    @Override
    public CommandType getCommandType() {
        return CMD_TYPE;
    }

    @Override
    public Either<CommitHookErrors, Worklog> handle(ApplicationUser user, MutableIssue issue, String commandName, List<String> args) {
        JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(user);
        WorklogResult result = this.worklogService.validateCreate((JiraServiceContext)jiraServiceContext, WorklogInputParametersImpl.builder().issue((Issue)issue).timeSpent(args.isEmpty() ? null : args.get(0)).comment(args.size() > 1 ? args.get(1) : null).startDate(new Date()).build());
        if (!jiraServiceContext.getErrorCollection().hasAnyErrors()) {
            return Either.value(this.worklogService.createAndAutoAdjustRemainingEstimate((JiraServiceContext)jiraServiceContext, result, true));
        }
        return Either.error(CommitHookErrors.fromErrorCollection(CMD_TYPE.getName(), issue.getKey(), jiraServiceContext.getErrorCollection()));
    }
}

