/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.commithook.handlers;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.IssueInputParametersImpl;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jirafisheyeplugin.commithook.CommandType;
import com.atlassian.jirafisheyeplugin.commithook.handlers.CommandHandler;
import com.atlassian.jirafisheyeplugin.commithook.restbeans.CommitHookErrors;
import com.atlassian.jirafisheyeplugin.util.Either;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class TransitionHandler
implements CommandHandler<Issue> {
    private static CommandType CMD_TYPE = CommandType.TRANSITION;
    private static final String NO_STATUS = "fisheye.commithooks.transition.unknownstatus";
    private static final String NO_COMMAND_PROVIDED_TEMPLATE = "fisheye.commithooks.transition.nocommand";
    private static final String NO_ALLOWED_ACTIONS_TEMPLATE = "fisheye.commithooks.transition.noactions";
    private static final String NO_MATCHING_ACTIONS_TEMPLATE = "fisheye.commithooks.transition.nomatch";
    private static final String MULTIPLE_ACTIONS_TEMPLATE = "fisheye.commithooks.transition.ambiguous";
    private IssueService issueService;
    private WorkflowManager workflowManager;
    private JiraAuthenticationContext jiraAuthenticationContext;

    public TransitionHandler(IssueService issueService, WorkflowManager workflowManager, JiraAuthenticationContext jiraAuthenticationContext) {
        this.issueService = issueService;
        this.workflowManager = workflowManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public CommandType getCommandType() {
        return CMD_TYPE;
    }

    @Override
    public Either<CommitHookErrors, Issue> handle(ApplicationUser user, MutableIssue issue, String commandName, List<String> args) {
        String cmd;
        I18nHelper i18nHelper = this.jiraAuthenticationContext.getI18nHelper();
        String string = cmd = args.isEmpty() ? null : args.get(0);
        if (cmd == null || cmd.equals("")) {
            return Either.error(CommitHookErrors.fromSingleError(CMD_TYPE.getName(), issue.getKey(), i18nHelper.getText(NO_COMMAND_PROVIDED_TEMPLATE, issue.getKey())));
        }
        Collection<ActionDescriptor> actions = this.getActionsForIssue(issue);
        Collection<ValidatedAction> validActions = this.getValidActions(actions, user, issue, (IssueInputParameters)new IssueInputParametersImpl());
        if (validActions.isEmpty()) {
            return Either.error(CommitHookErrors.fromSingleError(CMD_TYPE.getName(), issue.getKey(), i18nHelper.getText(NO_ALLOWED_ACTIONS_TEMPLATE, issue.getKey())));
        }
        Collection<ValidatedAction> matchingValidActions = this.getMatchingActionsForCommand(cmd, validActions);
        if (matchingValidActions.isEmpty()) {
            String validActionNames = StringUtils.join(this.getActionNamesIterator(validActions), ", ");
            return Either.error(CommitHookErrors.fromSingleError(CMD_TYPE.getName(), issue.getKey(), i18nHelper.getText(NO_MATCHING_ACTIONS_TEMPLATE, issue.getKey(), this.getIssueState((Issue)issue), cmd, validActionNames)));
        }
        if (matchingValidActions.size() > 1) {
            String validActionNames = StringUtils.join(this.getActionNamesIterator(matchingValidActions), ", ");
            return Either.error(CommitHookErrors.fromSingleError(CMD_TYPE.getName(), issue.getKey(), i18nHelper.getText(MULTIPLE_ACTIONS_TEMPLATE, cmd, issue.getKey(), this.getIssueState((Issue)issue), validActionNames)));
        }
        IssueService.TransitionValidationResult validation = matchingValidActions.iterator().next().validation;
        IssueService.IssueResult result = this.issueService.transition(user, validation);
        if (!result.isValid()) {
            return Either.error(CommitHookErrors.fromErrorCollection(CMD_TYPE.getName(), issue.getKey(), result.getErrorCollection()));
        }
        return Either.value(result.getIssue());
    }

    private String getIssueState(Issue issue) {
        I18nHelper i18nHelper = this.jiraAuthenticationContext.getI18nHelper();
        Status s = issue.getStatus();
        return s == null ? i18nHelper.getText(NO_STATUS) : s.getName();
    }

    private Iterator<String> getActionNamesIterator(Collection<ValidatedAction> matchingValidActions) {
        return Iterables.transform(matchingValidActions, (Function)new Function<ValidatedAction, String>(){

            public String apply(ValidatedAction in) {
                return in.action.getName();
            }
        }).iterator();
    }

    private Collection<ActionDescriptor> getActionsForIssue(MutableIssue issue) {
        return this.workflowManager.getWorkflow((Issue)issue).getAllActions();
    }

    private Collection<ValidatedAction> getMatchingActionsForCommand(String cmd, Collection<ValidatedAction> actions) {
        String cmdSanitized = cmd.trim().toLowerCase(Locale.US);
        String cmdWithSpaces = cmdSanitized.replace('-', ' ');
        ArrayList<ValidatedAction> firstShotActions = new ArrayList<ValidatedAction>();
        ArrayList<ValidatedAction> secondShotActions = new ArrayList<ValidatedAction>();
        for (ValidatedAction validatedAction : actions) {
            String name = validatedAction.action.getName().toLowerCase(Locale.US);
            if (name.equals(cmdSanitized)) {
                return Arrays.asList(validatedAction);
            }
            if (name.startsWith(cmdSanitized)) {
                firstShotActions.add(validatedAction);
                continue;
            }
            if (!name.startsWith(cmdWithSpaces)) continue;
            secondShotActions.add(validatedAction);
        }
        return firstShotActions.isEmpty() ? secondShotActions : firstShotActions;
    }

    private Collection<ValidatedAction> getValidActions(Collection<ActionDescriptor> actionsToValidate, ApplicationUser user, MutableIssue issue, IssueInputParameters parameters) {
        ArrayList<ValidatedAction> validations = new ArrayList<ValidatedAction>();
        for (ActionDescriptor ad : actionsToValidate) {
            IssueService.TransitionValidationResult validation = this.issueService.validateTransition(user, issue.getId(), ad.getId(), parameters);
            if (!validation.isValid()) continue;
            validations.add(new ValidatedAction(ad, validation));
        }
        return validations;
    }

    private class ValidatedAction {
        ActionDescriptor action;
        IssueService.TransitionValidationResult validation;

        public ValidatedAction(ActionDescriptor action, IssueService.TransitionValidationResult validation) {
            this.action = action;
            this.validation = validation;
        }
    }
}

