/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.commithook.handlers;

import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jirafisheyeplugin.commithook.CommandType;
import com.atlassian.jirafisheyeplugin.commithook.handlers.CommandHandler;
import com.atlassian.jirafisheyeplugin.commithook.restbeans.CommitHookErrors;
import com.atlassian.jirafisheyeplugin.util.Either;
import java.util.List;

public class CommentHandler
implements CommandHandler<Comment> {
    private static CommandType CMD_TYPE = CommandType.COMMENT;
    private CommentService commentService;

    public CommentHandler(CommentService commentService) {
        this.commentService = commentService;
    }

    @Override
    public CommandType getCommandType() {
        return CMD_TYPE;
    }

    @Override
    public Either<CommitHookErrors, Comment> handle(ApplicationUser user, MutableIssue issue, String commandName, List<String> args) {
        JiraServiceContextImpl jiraServiceContext = new JiraServiceContextImpl(user);
        Comment comment = this.commentService.create(user, (Issue)issue, args.isEmpty() ? null : args.get(0), true, jiraServiceContext.getErrorCollection());
        if (jiraServiceContext.getErrorCollection().hasAnyErrors()) {
            return Either.error(CommitHookErrors.fromErrorCollection(CMD_TYPE.getName(), issue.getKey(), jiraServiceContext.getErrorCollection()));
        }
        return Either.value(comment);
    }
}

