/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.commithook;

import com.atlassian.fugue.Iterables;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jirafisheyeplugin.commithook.CommandType;
import com.atlassian.jirafisheyeplugin.commithook.handlers.CommandHandler;
import com.atlassian.jirafisheyeplugin.commithook.handlers.CommentHandler;
import com.atlassian.jirafisheyeplugin.commithook.handlers.TransitionHandler;
import com.atlassian.jirafisheyeplugin.commithook.handlers.WorkLogHandler;
import com.atlassian.jirafisheyeplugin.commithook.restbeans.CommitCommands;
import com.atlassian.jirafisheyeplugin.commithook.restbeans.CommitHookErrors;
import com.atlassian.jirafisheyeplugin.util.Either;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.base.Objects;
import com.sun.jersey.spi.resource.Singleton;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;

@Singleton
@Path(value="/issues")
@Produces(value={"application/json"})
public class CommitHookREST {
    private static final String NO_COMMANDS = "fisheye.commithooks.commands.nocommands";
    private static final String BAD_COMMAND = "fisheye.commithooks.commands.badcommand";
    private static final String UNKNOWN_ISSUE = "fisheye.commithooks.commands.unknownissue";
    private static final CacheControl NO_CACHE = new CacheControl();
    private TransitionHandler transitionHandler;
    private CommentHandler commentHandler;
    private WorkLogHandler workLogHandler;
    private IssueManager issueManager;
    private JiraAuthenticationContext jiraAuthenticationContext;

    public CommitHookREST(IssueManager issueManager, TransitionHandler transitionHandler, CommentHandler commentHandler, WorkLogHandler workLogHandler, JiraAuthenticationContext jiraAuthenticationContext) {
        this.issueManager = issueManager;
        this.transitionHandler = transitionHandler;
        this.commentHandler = commentHandler;
        this.workLogHandler = workLogHandler;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @POST
    @AnonymousAllowed
    @Path(value="/{issueKey}/transition/{actionName}")
    public Response transition(@PathParam(value="issueKey") String issueKey, @PathParam(value="actionName") String actionName, @Context HttpHeaders headers) {
        this.ensureRequestIsFromApplink(headers);
        MutableIssue issue = this.getExistingIssue(issueKey, this.transitionHandler);
        Either<CommitHookErrors, Issue> result = this.transitionHandler.handle(this.getUser(), issue, this.transitionHandler.getCommandType().getName(), Arrays.asList(actionName));
        return CommitHookREST.formResponse(result.hasError() ? result.getError() : null);
    }

    @POST
    @AnonymousAllowed
    @Path(value="/{issueKey}/comment")
    @Consumes(value={"text/plain"})
    public Response comment(@PathParam(value="issueKey") String issueKey, String text, @Context HttpHeaders headers) {
        this.ensureRequestIsFromApplink(headers);
        MutableIssue issue = this.getExistingIssue(issueKey, this.commentHandler);
        Either<CommitHookErrors, Comment> result = this.commentHandler.handle(this.getUser(), issue, this.commentHandler.getCommandType().getName(), Arrays.asList(text));
        return CommitHookREST.formResponse(result.hasError() ? result.getError() : null);
    }

    @POST
    @AnonymousAllowed
    @Consumes(value={"text/plain"})
    @Path(value="/{issueKey}/time/{amount}")
    public Response logWork(@PathParam(value="issueKey") String issueKey, @PathParam(value="amount") String timeToLog, String workComment, @Context HttpHeaders headers) {
        this.ensureRequestIsFromApplink(headers);
        MutableIssue issue = this.getExistingIssue(issueKey, this.workLogHandler);
        Either<CommitHookErrors, Worklog> result = this.workLogHandler.handle(this.getUser(), issue, this.workLogHandler.getCommandType().getName(), Arrays.asList(timeToLog, workComment.isEmpty() ? null : workComment));
        return CommitHookREST.formResponse(result.hasError() ? result.getError() : null);
    }

    @POST
    @AnonymousAllowed
    @Consumes(value={"application/json"})
    @Path(value="/commands")
    public Response doCommands(CommitCommands commands) {
        I18nHelper i18nHelper = this.jiraAuthenticationContext.getI18nHelper();
        ApplicationUser user = this.getUser();
        if (commands == null || commands.getCommands().isEmpty()) {
            return CommitHookREST.formResponse(CommitHookErrors.fromSingleError("commands", "", i18nHelper.getText(NO_COMMANDS)));
        }
        CommitHookErrors errors = new CommitHookErrors();
        block5: for (CommitCommands.CommitCommand command : commands.getCommands()) {
            CommandType commandType = CommandType.getCommandType(command.getCommandName());
            MutableIssue issue = this.issueManager.getIssueObject(command.getIssueKey());
            if (issue == null) {
                errors.addError(command.getCommandName(), command.getIssueKey(), this.badIssueKey(command.getIssueKey()));
                continue;
            }
            switch (commandType) {
                case LOG_WORK: {
                    Either<CommitHookErrors, Worklog> logResult = this.workLogHandler.handle(user, issue, command.getCommandName(), command.getArguments());
                    if (!logResult.hasError()) continue block5;
                    errors.addErrors(logResult.getError());
                    continue block5;
                }
                case COMMENT: {
                    Either<CommitHookErrors, Comment> commentResult = this.commentHandler.handle(user, issue, command.getCommandName(), command.getArguments());
                    if (!commentResult.hasError()) continue block5;
                    errors.addErrors(commentResult.getError());
                    continue block5;
                }
                case TRANSITION: {
                    Either<CommitHookErrors, Issue> transitionResult = this.transitionHandler.handle(user, issue, command.getCommandName(), command.getArguments());
                    if (!transitionResult.hasError()) continue block5;
                    errors.addErrors(transitionResult.getError());
                    continue block5;
                }
            }
            errors.addError(command.getCommandName(), command.getIssueKey(), i18nHelper.getText(BAD_COMMAND, command.getCommandName(), command.getIssueKey()));
        }
        return CommitHookREST.formResponse(errors);
    }

    private static Response formResponse(CommitHookErrors errors) {
        if (errors == null || errors.isEmpty()) {
            return Response.ok().cacheControl(NO_CACHE).build();
        }
        return Response.status((int)400).entity((Object)errors).build();
    }

    private String badIssueKey(String key) {
        I18nHelper i18nHelper = this.jiraAuthenticationContext.getI18nHelper();
        return i18nHelper.getText(UNKNOWN_ISSUE, key);
    }

    private ApplicationUser getUser() {
        return this.jiraAuthenticationContext.getLoggedInUser();
    }

    private MutableIssue getExistingIssue(String issueKey, CommandHandler handler) {
        MutableIssue issue = this.issueManager.getIssueObject(issueKey);
        if (issue == null) {
            throw new BadIssueException(handler.getCommandType().getName(), issueKey, this.badIssueKey(issueKey));
        }
        return issue;
    }

    private void ensureRequestIsFromApplink(HttpHeaders headers) {
        List userAgents = (List)Objects.firstNonNull((Object)headers.getRequestHeader("User-Agent"), Collections.emptyList());
        String userAgent = (String)Iterables.first((Iterable)userAgents).getOrElse((Object)"");
        if (!userAgent.toLowerCase().contains("httpclient")) {
            throw new NonApplinkRequestException();
        }
    }

    static {
        NO_CACHE.setNoCache(true);
    }

    private static class NonApplinkRequestException
    extends WebApplicationException {
        public NonApplinkRequestException() {
            super(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Only AppLink requests are allowed").build());
        }
    }

    private static class BadIssueException
    extends WebApplicationException {
        public BadIssueException(String commandType, String issueKey, String message) {
            super(CommitHookREST.formResponse(CommitHookErrors.fromSingleError(commandType, issueKey, message)));
        }
    }
}

