/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.cache;

import com.atlassian.jirafisheyeplugin.cache.FishEyeCache;
import com.atlassian.jirafisheyeplugin.cache.FishEyeCacheImpl;
import com.atlassian.jirafisheyeplugin.domain.fisheye.Changeset;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeRepository;
import com.atlassian.jirafisheyeplugin.domain.fisheye.Revision;
import com.atlassian.seraph.auth.AuthenticationContext;

public class StatisticsStoringCacheImpl
extends FishEyeCacheImpl {
    private final int maxRevSize;
    private final int maxCsSize;
    private long revCount = 0L;
    private long csCount = 0L;
    private boolean hasCountOverflowed = false;

    public StatisticsStoringCacheImpl(int revCacheSize, int csCacheSize, AuthenticationContext authenticationContext) {
        super(revCacheSize, csCacheSize, authenticationContext);
        this.maxRevSize = revCacheSize;
        this.maxCsSize = csCacheSize;
    }

    @Override
    public void add(FishEyeRepository repository, Changeset changeset) {
        ++this.csCount;
        this.checkForOverflow();
        super.add(repository, changeset);
    }

    @Override
    public void add(FishEyeRepository repository, Revision revision) {
        ++this.revCount;
        this.checkForOverflow();
        super.add(repository, revision);
    }

    private void checkForOverflow() {
        if (this.revCount < 0L || this.csCount < 0L) {
            this.revCount = 0L;
            this.csCount = 0L;
            this.hasCountOverflowed = true;
        }
    }

    @Override
    public FishEyeCache.CacheStatistics getStatistics() {
        final int currentRevisions = this.cacheDisabled ? 0 : this.revCache.size();
        final int currentChangesets = this.cacheDisabled ? 0 : this.csCache.size();
        final long totalRevisions = this.revCount;
        final long totalChangesets = this.csCount;
        final boolean hasTotalsOverflowed = this.hasCountOverflowed;
        return new FishEyeCache.CacheStatistics(){

            @Override
            public int getMaxRevisions() {
                return StatisticsStoringCacheImpl.this.maxRevSize;
            }

            @Override
            public int getRevisions() {
                return currentRevisions;
            }

            @Override
            public int getMaxChangesets() {
                return StatisticsStoringCacheImpl.this.maxCsSize;
            }

            @Override
            public int getChangesets() {
                return currentChangesets;
            }

            @Override
            public long getTotalRevisions() {
                return totalRevisions;
            }

            @Override
            public long getTotalChangesets() {
                return totalChangesets;
            }

            @Override
            public boolean hasTotalsOverflowed() {
                return hasTotalsOverflowed;
            }
        };
    }
}

