/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.cache;

import com.atlassian.jirafisheyeplugin.cache.FishEyeCache;
import com.atlassian.jirafisheyeplugin.domain.fisheye.Changeset;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeRepository;
import com.atlassian.jirafisheyeplugin.domain.fisheye.Revision;
import com.atlassian.seraph.auth.AuthenticationContext;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;

public class FishEyeCacheImpl
implements FishEyeCache {
    protected Map<String, Revision> revCache = null;
    protected Map<String, Changeset> csCache = null;
    private AuthenticationContext authenticationContext;
    protected boolean cacheDisabled = false;

    public FishEyeCacheImpl(int revCacheSize, int csCacheSize, AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
        if (revCacheSize > 0 && csCacheSize > 0) {
            this.revCache = Collections.synchronizedMap(new LRUMap(revCacheSize));
            this.csCache = Collections.synchronizedMap(new LRUMap(csCacheSize));
        } else {
            this.cacheDisabled = true;
        }
    }

    @Override
    public void add(FishEyeRepository repository, Changeset changeset) {
        if (this.cacheDisabled) {
            return;
        }
        this.csCache.put(this.csKey(repository, changeset), changeset);
    }

    @Override
    public void add(FishEyeRepository repository, Revision revision) {
        if (this.cacheDisabled) {
            return;
        }
        String csKey = this.csKey(repository, revision.getCsid());
        this.revCache.put(this.revKey(revision, csKey), revision);
    }

    @Override
    public Changeset getChangeset(FishEyeRepository repository, String csid) {
        if (this.cacheDisabled) {
            return null;
        }
        return this.csCache.get(this.csKey(repository, csid));
    }

    @Override
    public Revision getRevision(FishEyeRepository repository, String path, String csid) {
        if (this.cacheDisabled) {
            return null;
        }
        return this.revCache.get(this.revKey(repository, csid, path));
    }

    protected String csKey(FishEyeRepository repository, Changeset changeset) {
        return this.csKey(repository, changeset.getCsid());
    }

    protected String csKey(FishEyeRepository repository, String csid) {
        StringBuilder sb = new StringBuilder();
        FishEyeInstance instance = repository.getInstance();
        if (instance != null && this.authenticationContext.getUser() != null) {
            sb.append(this.authenticationContext.getUser().getName());
        }
        sb.append(repository.getName());
        sb.append(csid);
        return sb.toString();
    }

    protected String revKey(FishEyeRepository repository, String csid, String path) {
        return this.csKey(repository, csid) + path;
    }

    protected String revKey(Revision revision, String csKey) {
        return csKey + revision.getPath();
    }

    @Override
    public FishEyeCache.CacheStatistics getStatistics() {
        return new FishEyeCache.CacheStatistics(){

            @Override
            public int getMaxRevisions() {
                return -1;
            }

            @Override
            public int getRevisions() {
                return -1;
            }

            @Override
            public int getMaxChangesets() {
                return -1;
            }

            @Override
            public int getChangesets() {
                return -1;
            }

            @Override
            public long getTotalRevisions() {
                return -1L;
            }

            @Override
            public long getTotalChangesets() {
                return -1L;
            }

            @Override
            public boolean hasTotalsOverflowed() {
                return false;
            }
        };
    }
}

