/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.servlet.filter.mapper;

import com.atlassian.jira.mobile.auth.ApplicationUserProvider;
import com.atlassian.jira.mobile.servlet.filter.mapper.DashboardURLTracker;
import com.atlassian.jira.mobile.servlet.filter.mapper.IssueNavURLTracker;
import com.atlassian.jira.mobile.servlet.filter.mapper.KickAssURLTracker;
import com.atlassian.jira.mobile.servlet.filter.mapper.MyJIRAHomeURLTracker;
import com.atlassian.jira.mobile.servlet.filter.mapper.URLTracker;
import com.atlassian.jira.mobile.servlet.filter.mapper.ViewIssueURLTracker;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;

@Service
public class MobileURLTrackerService {
    @Resource
    private ApplicationUserProvider userProvider;
    private final List<URLTracker> trackers = Lists.newArrayList();

    public MobileURLTrackerService() {
        this.trackers.add(new KickAssURLTracker());
        this.trackers.add(new ViewIssueURLTracker());
        this.trackers.add(new DashboardURLTracker());
        this.trackers.add(new MyJIRAHomeURLTracker());
        this.trackers.add(new IssueNavURLTracker());
    }

    public boolean matchesPath(String path) {
        for (URLTracker tracker : this.trackers) {
            if (!tracker.matches(path)) continue;
            return true;
        }
        return false;
    }

    public String mapPath(String path, HttpServletRequest request) {
        try {
            for (URLTracker tracker : this.trackers) {
                String fragment = tracker.map(path, request);
                if (fragment == null) continue;
                return fragment;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return null;
    }

    public boolean requiresLogin(String path, HttpServletRequest request, ApplicationUser user) {
        for (URLTracker tracker : this.trackers) {
            if (!tracker.requiresLogin(path, request, user)) continue;
            return true;
        }
        return false;
    }
}

