/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mobile.rest.util;

import com.google.common.collect.Lists;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class RestErrorResponse {
    @XmlElement
    private List<Error> errors;
    @XmlElement
    private String reasonKey;
    @XmlElement
    private String reasonCode;

    public RestErrorResponse() {
    }

    public RestErrorResponse(String reasonKey, String reasonCode) {
        this.reasonCode = reasonCode;
        this.reasonKey = reasonKey;
        this.errors = Lists.newArrayList();
    }

    public void addError(String errorMessage) {
        this.errors.add(new Error(errorMessage));
    }

    public void addError(String errorMessage, String field) {
        this.errors.add(new Error(errorMessage, field));
    }

    @XmlRootElement
    private static class Error {
        @XmlElement
        private String errorMessage;
        @XmlElement
        private String field;

        public Error() {
        }

        public Error(String errorMessage) {
            this(errorMessage, null);
        }

        public Error(String errorMessage, String field) {
            this.errorMessage = errorMessage;
            this.field = field;
        }
    }
}

