/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.renderer.internal.http;

import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.security.auth.trustedapps.EncryptedCertificate;
import com.atlassian.security.auth.trustedapps.TrustedApplicationUtils;
import com.atlassian.security.auth.trustedapps.TrustedApplicationsManager;
import com.atlassian.security.auth.trustedapps.request.TrustedRequest;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.ContentFetcherFactory;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.RemoteContentFetcherFactory;
import org.apache.shindig.gadgets.oauth.OAuthFetcherFactory;

@Scanned
@Singleton
public class TrustedAppContentFetcherFactory
extends ContentFetcherFactory {
    private final TrustedApplicationsManager trustedAppsManager;
    private final UserManager userManager;

    @Inject
    public TrustedAppContentFetcherFactory(RemoteContentFetcherFactory remoteContentFetcherFactory, OAuthFetcherFactory oauthFetcherFactory, @ComponentImport TrustedApplicationsManager trustedAppsManager, @ComponentImport UserManager userManager) {
        super(remoteContentFetcherFactory, oauthFetcherFactory);
        this.trustedAppsManager = trustedAppsManager;
        this.userManager = userManager;
    }

    public HttpResponse fetch(HttpRequest request) throws GadgetException {
        this.addTrustedAppHeaders(request, this.userManager.getRemoteUsername());
        return super.fetch(request);
    }

    private void addTrustedAppHeaders(final HttpRequest request, String username) {
        EncryptedCertificate userCertificate = this.createCertificate(username, request.getUri().toString());
        if (userCertificate != null && !StringUtils.isBlank((String)userCertificate.getID())) {
            TrustedApplicationUtils.addRequestParameters((EncryptedCertificate)userCertificate, (TrustedRequest)new TrustedRequest(){

                public void addRequestParameter(String name, String value) {
                    request.addHeader(name, value);
                }
            });
        }
    }

    private EncryptedCertificate createCertificate(String username, String url) {
        if (StringUtils.isNotBlank((String)username) && StringUtils.isNotBlank((String)url)) {
            return this.trustedAppsManager.getCurrentApplication().encode(username, url);
        }
        return null;
    }
}

