/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.renderer.internal.http;

import com.atlassian.gadgets.opensocial.spi.Whitelist;
import com.atlassian.gadgets.util.HttpTimeoutsProvider;
import com.atlassian.sal.api.ApplicationProperties;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.message.BasicHeader;
import org.apache.shindig.gadgets.http.HttpCache;
import org.apache.shindig.gadgets.http.HttpCacheKey;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;

@Singleton
public class HttpClientFetcher
implements HttpFetcher {
    private final Log log = LogFactory.getLog(HttpClientFetcher.class);
    private final HttpCache cache;
    private final Whitelist whitelist;
    private final HttpTimeoutsProvider httpTimeoutsProvider;

    @Inject
    public HttpClientFetcher(HttpCache cache, Whitelist whitelist, ApplicationProperties applicationProperties) {
        this.cache = cache;
        this.whitelist = whitelist;
        this.httpTimeoutsProvider = new HttpTimeoutsProvider(applicationProperties);
    }

    public org.apache.shindig.gadgets.http.HttpResponse fetch(HttpRequest request) {
        if (!this.whitelist.allows(request.getUri().toJavaUri())) {
            this.log.warn((Object)("A request to " + request.getUri() + " has been denied.  To allow requests to this URL add the application URL to your whitelist (http://confluence.atlassian.com/x/KQfCDQ )."));
            return new HttpResponseBuilder().setHttpStatusCode(403).setHeader("Content-Type", "text/plain").setResponseString("Requests to " + request.getUri() + " are not allowed.  See your administrator about configuring a whitelist entry for this destination (http://confluence.atlassian.com/x/KQfCDQ ).").create();
        }
        HttpCacheKey cacheKey = new HttpCacheKey(request);
        org.apache.shindig.gadgets.http.HttpResponse response = this.cache.getResponse(cacheKey, request);
        if (response != null) {
            return response;
        }
        try {
            HttpUriRequest hcRequest = this.newHcRequest(request);
            if (request.getPostBodyLength() > 0) {
                ((HttpEntityEnclosingRequest)hcRequest).setEntity((HttpEntity)new InputStreamEntity(request.getPostBody(), (long)request.getPostBodyLength()));
            }
            HttpResponse hcResponse = this.newHttpClient(request).execute(hcRequest);
            response = this.makeResponse(hcResponse);
            return this.cache.addResponse(cacheKey, request, response);
        }
        catch (SocketTimeoutException e) {
            this.log.debug((Object)("Timeout performing a request to: " + request.getUri()), (Throwable)e);
            return org.apache.shindig.gadgets.http.HttpResponse.timeout();
        }
        catch (SocketException e) {
            this.log.debug((Object)("Networking/connection error performing a request to: " + request.getUri()), (Throwable)e);
            return org.apache.shindig.gadgets.http.HttpResponse.error();
        }
        catch (IOException e) {
            this.log.error((Object)("Unable to perform a request to: " + request.getUri()), (Throwable)e);
            return org.apache.shindig.gadgets.http.HttpResponse.error();
        }
    }

    private HttpClient newHttpClient(HttpRequest request) {
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(this.httpTimeoutsProvider.getConnectionTimeout()).build();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        SystemDefaultRoutePlanner routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
        httpClientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
        httpClientBuilder.setDefaultSocketConfig(socketConfig);
        httpClientBuilder.setDefaultHeaders((Collection)ImmutableSet.of((Object)new BasicHeader("Accept-Encoding", "gzip, deflate")));
        if (request.getFollowRedirects()) {
            RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setMaxRedirects(3);
            httpClientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
        } else {
            httpClientBuilder.disableRedirectHandling();
        }
        return httpClientBuilder.build();
    }

    private HttpUriRequest newHcRequest(HttpRequest request) throws IOException {
        URI uri = request.getUri().toJavaUri();
        HttpUriRequest httpUriRequest = HttpMethod.valueOf(request.getMethod()).newMessage(uri);
        for (Map.Entry entry : request.getHeaders().entrySet()) {
            httpUriRequest.addHeader((String)entry.getKey(), StringUtils.join((Collection)((Collection)entry.getValue()), (char)','));
        }
        return httpUriRequest;
    }

    private org.apache.shindig.gadgets.http.HttpResponse makeResponse(HttpResponse hcResponse) throws IOException {
        HttpResponseBuilder builder = new HttpResponseBuilder();
        for (Header header : hcResponse.getAllHeaders()) {
            builder.addHeader(header.getName(), header.getValue());
        }
        return builder.setHttpStatusCode(hcResponse.getStatusLine().getStatusCode()).setResponse(IOUtils.toByteArray((InputStream)hcResponse.getEntity().getContent())).create();
    }

    private static enum HttpMethod {
        GET,
        POST,
        DELETE,
        PUT,
        HEAD,
        OPTIONS,
        TRACE;


        public HttpUriRequest newMessage(URI uri) {
            switch (this) {
                case GET: {
                    return new HttpGet(uri);
                }
                case POST: {
                    return new HttpPost(uri);
                }
                case DELETE: {
                    return new HttpDelete(uri);
                }
                case PUT: {
                    return new HttpPut(uri);
                }
                case HEAD: {
                    return new HttpHead(uri);
                }
                case OPTIONS: {
                    return new HttpOptions(uri);
                }
                case TRACE: {
                    return new HttpTrace(uri);
                }
            }
            throw new IllegalStateException("Just not possible");
        }
    }
}

