/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.opensocial.internal;

import com.atlassian.gadgets.opensocial.OpenSocialRequestContext;
import com.atlassian.gadgets.opensocial.model.Activity;
import com.atlassian.gadgets.opensocial.model.ActivityId;
import com.atlassian.gadgets.opensocial.model.AppId;
import com.atlassian.gadgets.opensocial.model.Group;
import com.atlassian.gadgets.opensocial.model.MediaItem;
import com.atlassian.gadgets.opensocial.model.Person;
import com.atlassian.gadgets.opensocial.model.PersonId;
import com.atlassian.gadgets.opensocial.spi.PersonService;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.social.core.model.ActivityImpl;
import org.apache.shindig.social.core.model.MediaItemImpl;
import org.apache.shindig.social.core.model.NameImpl;
import org.apache.shindig.social.core.model.PersonImpl;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.model.MediaItem;
import org.apache.shindig.social.opensocial.model.Name;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.UserId;

class ShindigOpenSocialTypeAdapter {
    private ShindigOpenSocialTypeAdapter() {
        throw new RuntimeException(ShindigOpenSocialTypeAdapter.class.getName() + " cannot be instantiated");
    }

    static org.apache.shindig.social.opensocial.model.Person convertPersonToShindigPerson(Person person) {
        if (person == null) {
            return null;
        }
        return new PersonImpl(person.getPersonId().toString(), person.getPersonId().toString(), (Name)new NameImpl(person.getPersonId().toString()));
    }

    static Activity convertActivityToShindigActivity(com.atlassian.gadgets.opensocial.model.Activity from, Set<String> fields) {
        if (from == null) {
            return null;
        }
        Predicate fieldFilter = ShindigOpenSocialTypeAdapter.isNullOrEmpty(fields) ? Predicates.alwaysTrue() : Predicates.compose((Predicate)Predicates.in(fields), (Function)Functions.toStringFunction());
        ActivityImpl shindigActivity = new ActivityImpl();
        if (fieldFilter.apply((Object)Activity.Field.APP_ID.toString())) {
            shindigActivity.setAppId(from.getAppId().toString());
        }
        if (fieldFilter.apply((Object)Activity.Field.BODY.toString())) {
            shindigActivity.setBody(from.getBody());
        }
        if (fieldFilter.apply((Object)Activity.Field.EXTERNAL_ID.toString())) {
            shindigActivity.setExternalId(from.getExternalId());
        }
        if (from.getId() != null && fieldFilter.apply((Object)Activity.Field.ID.toString())) {
            shindigActivity.setId(from.getId().toString());
        }
        if (fieldFilter.apply((Object)Activity.Field.LAST_UPDATED.toString())) {
            shindigActivity.setUpdated(from.getUpdated());
        }
        if (fieldFilter.apply((Object)Activity.Field.MEDIA_ITEMS.toString())) {
            List shindigMediaItems = Lists.transform((List)from.getMediaItems(), ShindigOpenSocialTypeAdapter.mediaItemToShindigMediaItemFunction());
            shindigActivity.setMediaItems(shindigMediaItems);
        }
        if (fieldFilter.apply((Object)Activity.Field.POSTED_TIME.toString())) {
            shindigActivity.setPostedTime(from.getPostedTime());
        }
        if (fieldFilter.apply((Object)Activity.Field.PRIORITY.toString())) {
            shindigActivity.setPriority(from.getPriority());
        }
        if (fieldFilter.apply((Object)Activity.Field.STREAM_FAVICON_URL.toString())) {
            shindigActivity.setStreamFaviconUrl(from.getStreamFaviconUrl());
        }
        if (fieldFilter.apply((Object)Activity.Field.STREAM_SOURCE_URL.toString())) {
            shindigActivity.setStreamSourceUrl(from.getStreamSourceUrl());
        }
        if (fieldFilter.apply((Object)Activity.Field.STREAM_TITLE.toString())) {
            shindigActivity.setStreamTitle(from.getStreamTitle());
        }
        if (fieldFilter.apply((Object)Activity.Field.STREAM_URL.toString())) {
            shindigActivity.setStreamUrl(from.getStreamUrl());
        }
        if (fieldFilter.apply((Object)Activity.Field.URL.toString())) {
            shindigActivity.setUrl(from.getUrl());
        }
        if (fieldFilter.apply((Object)Activity.Field.TITLE.toString())) {
            shindigActivity.setTitle(from.getTitle());
        }
        if (from.getUserId() != null && fieldFilter.apply((Object)Activity.Field.USER_ID.toString())) {
            shindigActivity.setUserId(from.getUserId().toString());
        }
        return shindigActivity;
    }

    private static boolean isNullOrEmpty(Set<String> fields) {
        return fields == null || fields.isEmpty();
    }

    static com.atlassian.gadgets.opensocial.model.Activity convertShindigActivityToActivity(Activity from) {
        if (from == null) {
            return null;
        }
        Activity.Builder builder = new Activity.Builder(from.getTitle()).body(from.getBody()).externalId(from.getExternalId()).postedTime(from.getPostedTime()).priority(from.getPriority()).streamFaviconUrl(from.getStreamFaviconUrl()).streamSourceUrl(from.getStreamSourceUrl()).streamTitle(from.getStreamTitle()).streamUrl(from.getStreamUrl()).updated(from.getUpdated()).url(from.getUrl());
        if (from.getAppId() != null) {
            builder.appId(AppId.valueOf((String)from.getAppId()));
        }
        if (from.getId() != null) {
            builder.id(ActivityId.valueOf((String)from.getId()));
        }
        if (from.getMediaItems() != null) {
            List mediaItems = Lists.transform((List)from.getMediaItems(), ShindigOpenSocialTypeAdapter.shindigMediaItemToMediaItemFunction());
            builder.mediaItems(mediaItems);
        }
        if (from.getUserId() != null) {
            builder.userId(PersonId.valueOf((String)from.getUserId()));
        }
        return builder.build();
    }

    static Group groupIdToGroup(GroupId groupId) {
        switch (groupId.getType()) {
            case all: {
                return Group.ALL;
            }
            case self: {
                return Group.SELF;
            }
            case friends: {
                return Group.FRIENDS;
            }
        }
        return Group.of((String)groupId.getGroupId());
    }

    static OpenSocialRequestContext convertShindigSecurityTokenToRequestContext(final SecurityToken token) {
        return new OpenSocialRequestContext(){

            public String getOwnerId() {
                return token.getOwnerId();
            }

            public String getViewerId() {
                return token.getViewerId();
            }

            public boolean isAnonymous() {
                return token.isAnonymous();
            }

            public String getActiveUrl() {
                return token.getActiveUrl();
            }
        };
    }

    static Function<Person, org.apache.shindig.social.opensocial.model.Person> personToShindigPersonFunction() {
        return PersonToShindigPerson.FUNCTION;
    }

    static Set<Person> getPeopleFromUserIds(PersonService personService, Set<UserId> userIds, GroupId groupId, SecurityToken token) {
        Group group = ShindigOpenSocialTypeAdapter.groupIdToGroup(groupId);
        HashSet<String> personIds = new HashSet<String>();
        OpenSocialRequestContext openSocialRequestContext = ShindigOpenSocialTypeAdapter.convertShindigSecurityTokenToRequestContext(token);
        for (UserId userId : userIds) {
            personIds.add(userId.getUserId(token));
        }
        return personService.getPeople(personIds, group, openSocialRequestContext);
    }

    static Set<PersonId> getPeopleIdsFromUserIds(PersonService personService, Set<UserId> userIds, GroupId groupId, SecurityToken token) {
        Set<Person> people = ShindigOpenSocialTypeAdapter.getPeopleFromUserIds(personService, userIds, groupId, token);
        HashSet<PersonId> result = new HashSet<PersonId>();
        for (Person person : people) {
            result.add(person.getPersonId());
        }
        return result;
    }

    static Function<com.atlassian.gadgets.opensocial.model.Activity, Activity> activityToShindigActivityFunction(final Set<String> fields) {
        return new Function<com.atlassian.gadgets.opensocial.model.Activity, Activity>(){

            public Activity apply(com.atlassian.gadgets.opensocial.model.Activity from) {
                return ShindigOpenSocialTypeAdapter.convertActivityToShindigActivity(from, fields);
            }
        };
    }

    static org.apache.shindig.social.opensocial.model.MediaItem convertMediaItemToShindigMediaItem(MediaItem from) {
        if (from == null) {
            return null;
        }
        return new MediaItemImpl(from.getMimeType(), from.getType() != null ? MediaItem.Type.valueOf((String)from.getType().toString().toUpperCase()) : null, from.getUrl().toString());
    }

    static Function<MediaItem, org.apache.shindig.social.opensocial.model.MediaItem> mediaItemToShindigMediaItemFunction() {
        return new Function<MediaItem, org.apache.shindig.social.opensocial.model.MediaItem>(){

            public org.apache.shindig.social.opensocial.model.MediaItem apply(MediaItem from) {
                return ShindigOpenSocialTypeAdapter.convertMediaItemToShindigMediaItem(from);
            }
        };
    }

    static MediaItem convertShindigMediaItemToMediaItem(org.apache.shindig.social.opensocial.model.MediaItem from) {
        if (from == null) {
            return null;
        }
        return new MediaItem.Builder(URI.create(from.getUrl())).mimeType(from.getMimeType()).type(from.getType() != null ? MediaItem.Type.valueOf((String)from.getType().toString().toUpperCase()) : null).build();
    }

    static Function<org.apache.shindig.social.opensocial.model.MediaItem, MediaItem> shindigMediaItemToMediaItemFunction() {
        return new Function<org.apache.shindig.social.opensocial.model.MediaItem, MediaItem>(){

            public MediaItem apply(org.apache.shindig.social.opensocial.model.MediaItem from) {
                return ShindigOpenSocialTypeAdapter.convertShindigMediaItemToMediaItem(from);
            }
        };
    }

    private static enum PersonToShindigPerson implements Function<Person, org.apache.shindig.social.opensocial.model.Person>
    {
        FUNCTION;


        public org.apache.shindig.social.opensocial.model.Person apply(Person from) {
            return ShindigOpenSocialTypeAdapter.convertPersonToShindigPerson(from);
        }
    }
}

