/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.util;

import com.atlassian.applinks.core.util.Message;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Preconditions;
import java.io.Serializable;

public class MessageFactory {
    private final I18nResolver resolver;

    public MessageFactory(I18nResolver resolver) {
        this.resolver = (I18nResolver)Preconditions.checkNotNull((Object)resolver, (Object)"resolver");
    }

    public Message newI18nMessage(final String key, final Serializable ... params) {
        Preconditions.checkNotNull((Object)this.resolver, (Object)"resolver");
        Preconditions.checkNotNull((Object)key, (Object)"key");
        Preconditions.checkNotNull((Object)params, (Object)"params");
        return new Message(){

            public String toString() {
                return MessageFactory.this.resolver.getText(key, params);
            }
        };
    }

    public Message newLocalizedMessage(final String message) {
        return new Message(){

            public String toString() {
                return message;
            }
        };
    }
}

