/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.application.host.util;

import com.atlassian.fugue.Option;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class Arguments {
    private Arguments() {
    }

    public static String checkArgumentNotBlank(String argument, String argumentName) {
        Arguments.checkArgumentNotNull(argument, argumentName);
        if (StringUtils.isBlank((CharSequence)argument)) {
            throw new IllegalArgumentException(String.format("Argument '%s' must not be blank.", argumentName));
        }
        return argument;
    }

    public static <T> T checkArgumentNotNull(@Nullable T argument, String argumentName) {
        if (argument == null) {
            throw new NullPointerException(String.format("Argument '%s' must not be null.", argumentName));
        }
        return argument;
    }

    public static Option<String> checkArgumentNotBlank(Option<String> argument, String argumentName) {
        Arguments.checkArgumentNotNull(argument, argumentName);
        if (argument.isDefined() && StringUtils.isBlank((CharSequence)((CharSequence)argument.get()))) {
            throw new IllegalArgumentException(String.format("Argument '%s' must not be blank.", argumentName));
        }
        return argument;
    }
}

