/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.application.host;

import com.atlassian.application.api.Application;
import com.atlassian.application.api.ApplicationAccess;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.api.ApplicationManager;
import com.atlassian.application.api.PluginApplication;
import com.atlassian.application.host.ApplicationAccessFactory;
import com.atlassian.application.host.ApplicationConfigurationManager;
import com.atlassian.application.host.i18n.I18nResolver;
import com.atlassian.application.host.license.LicenseLocator;
import com.atlassian.application.host.plugin.PluginApplicationImpl;
import com.atlassian.application.host.plugin.PluginApplicationMetaData;
import com.atlassian.application.host.plugin.PluginApplicationMetaDataManager;
import com.atlassian.application.host.util.Arguments;
import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.license.SingleProductLicenseDetailsView;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.Collections;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public abstract class AbstractApplicationManager
implements ApplicationManager {
    private final I18nResolver resolver;
    private final PluginApplicationMetaDataManager pluginApplications;
    private final LicenseLocator licenseLocator;
    private final ApplicationAccessFactory applicationAccessFactory;
    private final ApplicationConfigurationManager appConfigManager;

    protected AbstractApplicationManager(PluginApplicationMetaDataManager pluginApplications, I18nResolver i18nResolver, LicenseLocator licenseLocator, ApplicationAccessFactory applicationAccessFactory, ApplicationConfigurationManager appConfigManager) {
        this.resolver = Arguments.checkArgumentNotNull(i18nResolver, "i18n");
        this.pluginApplications = Arguments.checkArgumentNotNull(pluginApplications, "pluginApplications");
        this.licenseLocator = Arguments.checkArgumentNotNull(licenseLocator, "licenseLocator");
        this.applicationAccessFactory = Arguments.checkArgumentNotNull(applicationAccessFactory, "accessFactory");
        this.appConfigManager = Arguments.checkArgumentNotNull(appConfigManager, "appConfigManager");
    }

    public final Iterable<Application> getApplications() {
        return com.google.common.collect.Iterables.concat(Collections.singleton(this.getPlatform()), this.pluginApplications());
    }

    public final Option<Application> getApplication(final ApplicationKey key) {
        Arguments.checkArgumentNotNull(key, "key");
        return Iterables.findFirst(this.getApplications(), (Predicate)new Predicate<Application>(){

            public boolean apply(@Nullable Application input) {
                assert (input != null);
                return input.getKey().equals((Object)key);
            }
        });
    }

    public final <A extends Application> Option<A> getApplication(ApplicationKey key, final Class<A> type) {
        Arguments.checkArgumentNotNull(key, "key");
        Arguments.checkArgumentNotNull(type, "type");
        return this.getApplication(key).flatMap(new Function<Application, Option<A>>(){

            public Option<A> apply(@Nullable Application input) {
                if (type.isInstance(input)) {
                    return Option.some(type.cast(input));
                }
                return Option.none((Class)type);
            }
        });
    }

    public final Option<ApplicationAccess> getAccess(ApplicationKey key) {
        return this.getApplication(key).map((Function)new Function<Application, ApplicationAccess>(){

            public ApplicationAccess apply(@Nullable Application input) {
                assert (input != null);
                return input.getAccess();
            }
        });
    }

    private Supplier<Option<SingleProductLicenseDetailsView>> viewSupplier(final ApplicationKey key) {
        return new Supplier<Option<SingleProductLicenseDetailsView>>(){

            public Option<SingleProductLicenseDetailsView> get() {
                return (Option)AbstractApplicationManager.this.licenseLocator.apply(key);
            }
        };
    }

    private Supplier<ApplicationAccess> accessSuppler(final ApplicationKey key, final DateTime buildDate) {
        return new Supplier<ApplicationAccess>(){

            public ApplicationAccess get() {
                return AbstractApplicationManager.this.applicationAccessFactory.access(key, buildDate);
            }
        };
    }

    private Iterable<PluginApplication> pluginApplications() {
        return com.google.common.collect.Iterables.transform(this.pluginApplications.getApplications(), (Function)new Function<PluginApplicationMetaData, PluginApplication>(){

            public PluginApplication apply(@Nullable PluginApplicationMetaData input) {
                assert (input != null);
                return new PluginApplicationImpl(input, AbstractApplicationManager.this.resolver, (Supplier<Option<SingleProductLicenseDetailsView>>)Suppliers.memoize((Supplier)AbstractApplicationManager.this.viewSupplier(input.getKey())), (Supplier<ApplicationAccess>)Suppliers.memoize((Supplier)AbstractApplicationManager.this.accessSuppler(input.getKey(), input.buildDate())), AbstractApplicationManager.this.appConfigManager);
            }
        });
    }
}

