/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.nimbus.parser;

import com.atlassian.asap.api.JwsHeader;
import com.atlassian.asap.api.JwtClaims;
import com.atlassian.asap.core.exception.JwtParseException;
import com.atlassian.asap.core.exception.MissingRequiredClaimException;
import com.atlassian.asap.core.exception.MissingRequiredHeaderException;
import com.atlassian.asap.core.exception.UnsupportedAlgorithmException;
import com.atlassian.asap.core.parser.JwtParser;
import com.atlassian.asap.core.parser.VerifiableJwt;
import com.atlassian.asap.nimbus.parser.NimbusVerifiableJwt;
import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import net.minidev.json.JSONObject;

public class NimbusJwtParser
implements JwtParser {
    @Override
    public VerifiableJwt parse(String serializedJwt) throws JwtParseException, UnsupportedAlgorithmException {
        JWTClaimsSet claims;
        JWSObject jwsObject;
        try {
            jwsObject = JWSObject.parse((String)serializedJwt);
            this.validateRequiredHeaders(jwsObject);
            JSONObject jsonPayload = jwsObject.getPayload().toJSONObject();
            claims = JWTClaimsSet.parse((JSONObject)jsonPayload);
        }
        catch (ParseException e) {
            throw new JwtParseException(e);
        }
        this.validateRequiredClaims(claims);
        return NimbusVerifiableJwt.buildVerifiableJwt(jwsObject, claims);
    }

    private void validateRequiredHeaders(JWSObject jwsObject) throws MissingRequiredHeaderException {
        if (jwsObject.getHeader().getAlgorithm() == null || jwsObject.getHeader().getAlgorithm() == Algorithm.NONE) {
            throw new MissingRequiredHeaderException(JwsHeader.Header.ALGORITHM);
        }
        if (jwsObject.getHeader().getKeyID() == null) {
            throw new MissingRequiredHeaderException(JwsHeader.Header.KEY_ID);
        }
    }

    private void validateRequiredClaims(JWTClaimsSet claims) throws MissingRequiredClaimException {
        NimbusJwtParser.checkClaimNotNull(claims.getAudience(), JwtClaims.Claim.AUDIENCE);
        NimbusJwtParser.checkClaimNotNull(claims.getIssuer(), JwtClaims.Claim.ISSUER);
        NimbusJwtParser.checkClaimNotNull(claims.getJWTID(), JwtClaims.Claim.JWT_ID);
        NimbusJwtParser.checkClaimNotNull(claims.getIssueTime(), JwtClaims.Claim.ISSUED_AT);
        NimbusJwtParser.checkClaimNotNull(claims.getExpirationTime(), JwtClaims.Claim.EXPIRY);
    }

    private static void checkClaimNotNull(Object claimValue, JwtClaims.Claim claim) throws MissingRequiredClaimException {
        if (claimValue == null) {
            throw new MissingRequiredClaimException(claim);
        }
    }
}

