/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.asap.core.keys.privatekey;

import com.atlassian.asap.core.keys.DataUriKeyReader;
import com.atlassian.asap.core.keys.privatekey.DataUriKeyProvider;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemPropertyKeyProvider
extends DataUriKeyProvider {
    static final String URL_SCHEME = "sysprop";
    private static final Logger logger = LoggerFactory.getLogger(SystemPropertyKeyProvider.class);

    private SystemPropertyKeyProvider(String propertyName, DataUriKeyReader keyReader) {
        super(URI.create(SystemPropertyKeyProvider.getSystemProperty(propertyName)), keyReader);
    }

    private static String getSystemProperty(String propertyName) {
        logger.debug("Reading private key from system property {}", (Object)propertyName);
        return Optional.ofNullable(System.getProperty(propertyName)).orElseThrow(() -> new IllegalArgumentException("Undefined System property: " + propertyName));
    }

    public static SystemPropertyKeyProvider fromUri(URI uri, DataUriKeyReader keyReader) {
        Preconditions.checkArgument((boolean)uri.isAbsolute(), (Object)"URL must be absolute");
        Preconditions.checkArgument((boolean)URL_SCHEME.equals(uri.getScheme()), (Object)"URL must have sysprop scheme");
        Preconditions.checkArgument((uri.getPath() != null && uri.getPath().startsWith("/") ? 1 : 0) != 0, (Object)"URL must have a path component");
        Preconditions.checkArgument((uri.getQuery() == null ? 1 : 0) != 0, (Object)"URL must not have a query component");
        Preconditions.checkArgument((uri.getAuthority() == null ? 1 : 0) != 0, (Object)"URL must not have an authority component");
        String basePropertyName = uri.getPath().substring(1);
        return new SystemPropertyKeyProvider(basePropertyName, keyReader);
    }
}

