/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.issuenavigator.webaction;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.issue.worklog.TimeTrackingConfiguration;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.components.issueviewer.action.IssueBean;
import com.atlassian.jira.components.issueviewer.config.IssueNavFeatures;
import com.atlassian.jira.components.issueviewer.service.ActionUtilsService;
import com.atlassian.jira.components.issueviewer.viewissue.webpanel.IssueWebPanelsBean;
import com.atlassian.jira.config.Feature;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcutManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.projects.api.service.FlushHeadEarlyUtils;
import com.atlassian.jira.projects.api.sidebar.ProjectSidebarRenderer;
import com.atlassian.jira.projects.issuenavigator.IssueRenderService;
import com.atlassian.jira.projects.issuenavigator.helpers.ProjectIssueNavigatorHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.util.JiraContactHelper;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.IssueActionSupport;
import com.atlassian.jira.web.pagebuilder.Decorator;
import com.atlassian.jira.web.pagebuilder.GeneralJspDecorator;
import com.atlassian.jira.web.pagebuilder.JiraPageBuilderService;
import com.atlassian.jira.web.pagebuilder.PageBuilder;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.seraph.util.RedirectUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;

@Scanned
public class ProjectIssueNavigatorAction
extends IssueActionSupport {
    private static final String BROWSE_CONTEXT = "jira.browse.project";
    private static final String PROJECT_ISSUE_NAVIGATOR_CONTEXT = "project.issue.navigator";
    private static final String JIRA_VIEW_ISSUE_CONTEXT = "jira.view.issue";
    private static final String SERVER_RENDERED_ISSUE_KEY = "com.atlassian.jira.jira-projects-issue-navigator:server-rendered";
    private static final String ISSUE_PROJECT_NAVIGATOR_SIDEBAR_KEY = "com.atlassian.jira.jira-projects-issue-navigator:sidebar-issue-navigator";
    private static final String ISSUE_SEARCH_VIEW = "issueSearchWithSidebar";
    private static final String VIEW_ISSUE_VIEW = "issueViewWithSidebar";
    private static final String VIEW_ISSUE_ERROR = "issueViewNotFound";
    private final ProjectSidebarRenderer projectSidebarRenderer;
    private final ProjectService projectService;
    private final JiraPageBuilderService jiraPageBuilderService;
    private final KeyboardShortcutManager keyboardShortcutManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final FlushHeadEarlyUtils flushHeadEarlyUtils;
    private final IssueRenderService issueRenderService;
    private final ProjectIssueNavigatorHelper projectIssueNavigatorHelper;
    private final FeatureManager featureManager;
    private final ActionUtilsService actionUtilsService;
    private final PermissionManager permissionManager;
    private final JiraContactHelper contactHelper;
    private Optional<String> issueKey = Optional.empty();
    private Optional<String> projectKey = Optional.empty();
    private Optional<String> filter = Optional.empty();
    private Optional<String> orderby = Optional.empty();
    private String title;
    private Optional<Project> project;
    private final ViewIssueData viewIssueData = new ViewIssueData();

    @Inject
    public ProjectIssueNavigatorAction(@ComponentImport ProjectSidebarRenderer projectSidebarRenderer, @ComponentImport IssueManager issueManager, @ComponentImport CustomFieldManager customFieldManager, @ComponentImport AttachmentManager attachmentManager, @ComponentImport ProjectManager projectManager, @ComponentImport ProjectService projectService, @ComponentImport PermissionManager permissionManager, @ComponentImport VersionManager versionManager, @ComponentImport UserIssueHistoryManager userHistoryManager, @ComponentImport TimeTrackingConfiguration timeTrackingConfiguration, @ComponentImport JiraPageBuilderService jiraPageBuilderService, @ComponentImport KeyboardShortcutManager keyboardShortcutManager, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport FlushHeadEarlyUtils flushHeadEarlyUtils, IssueRenderService issueRenderService, ProjectIssueNavigatorHelper projectIssueNavigatorHelper, FeatureManager featureManager, @ComponentImport JiraContactHelper jiraContactHelper, @ComponentImport ActionUtilsService actionUtilsService) {
        super(issueManager, customFieldManager, attachmentManager, projectManager, permissionManager, versionManager, userHistoryManager, timeTrackingConfiguration);
        this.projectSidebarRenderer = projectSidebarRenderer;
        this.projectService = projectService;
        this.jiraPageBuilderService = jiraPageBuilderService;
        this.keyboardShortcutManager = keyboardShortcutManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.flushHeadEarlyUtils = flushHeadEarlyUtils;
        this.issueRenderService = issueRenderService;
        this.projectIssueNavigatorHelper = projectIssueNavigatorHelper;
        this.featureManager = featureManager;
        this.permissionManager = permissionManager;
        this.contactHelper = jiraContactHelper;
        this.actionUtilsService = actionUtilsService;
    }

    public String doIssueSearchWithSidebar() throws Exception {
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
        Optional<ServiceOutcome> getProjectResult = this.projectKey.map(key -> this.projectService.getProjectByKey(loggedInUser, key));
        if (!getProjectResult.isPresent() || getProjectResult.filter(outcome -> !outcome.isValid()).isPresent()) {
            if (loggedInUser == null) {
                return this.redirectToLoginPage();
            }
            return this.notFound();
        }
        this.project = getProjectResult.filter(ServiceResult::isValid).map(ServiceOutcome::get);
        this.requireResources(this.project);
        this.projectSidebarRenderer.requireResources(this.project.get(), ISSUE_PROJECT_NAVIGATOR_SIDEBAR_KEY);
        this.projectIssueNavigatorHelper.setUpResponse(this.getHttpResponse(), this.project);
        this.flushHeadEarly();
        this.projectIssueNavigatorHelper.embedSearchResults(this.project, this.filter, this.orderby, this.issueKey);
        this.jiraPageBuilderService.assembler().data().requireData("com.atlassian.jira.jira-issue-nav-components:inline-edit-enabled", Boolean.valueOf(this.isInlineEditEnabled()));
        return ISSUE_SEARCH_VIEW;
    }

    public String doIssueViewWithSidebar() throws Exception {
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
        Optional<MutableIssue> optionalIssue = this.issueKey.map(key -> this.getIssueManager().getIssueByCurrentKey(key)).filter(issue -> this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, (Issue)issue, loggedInUser));
        if (!optionalIssue.isPresent() && loggedInUser == null) {
            return this.redirectToLoginPage();
        }
        this.project = optionalIssue.map(Issue::getProjectObject);
        this.requireResources(this.project);
        if (!this.project.isPresent()) {
            return this.notFound();
        }
        Issue issue2 = (Issue)optionalIssue.get();
        this.projectSidebarRenderer.requireResources(this.project.get(), ISSUE_PROJECT_NAVIGATOR_SIDEBAR_KEY);
        this.projectIssueNavigatorHelper.setUpResponse(this.getHttpResponse(), this.project);
        this.projectIssueNavigatorHelper.setMetadata("serverRenderedViewIssue", "true");
        this.jiraPageBuilderService.assembler().data().requireData(SERVER_RENDERED_ISSUE_KEY, Boolean.valueOf(true));
        this.flushHeadEarly();
        this.jiraPageBuilderService.assembler().data().requireData("com.atlassian.jira.jira-issue-nav-components:inline-edit-enabled", Boolean.valueOf(this.isInlineEditEnabled()));
        if (this.filter.isPresent()) {
            this.projectIssueNavigatorHelper.embedSearchResults(this.project, this.filter, this.orderby, this.issueKey);
            this.viewIssueData.showCollapse = true;
        }
        this.issueRenderService.render(issue2.getKey(), (s, o) -> {
            switch (s) {
                case "issue": {
                    this.viewIssueData.issue = (IssueBean)o;
                    break;
                }
                case "panels": {
                    this.viewIssueData.panels = (IssueWebPanelsBean)o;
                }
            }
        });
        this.title = "[" + issue2.getKey() + "] " + issue2.getSummary();
        return VIEW_ISSUE_VIEW;
    }

    private String redirectToLoginPage() throws IOException {
        this.getHttpResponse().sendRedirect(RedirectUtils.getLoginUrl((HttpServletRequest)this.getHttpRequest()));
        return "none";
    }

    private String notFound() {
        this.getHttpResponse().setStatus(404);
        return VIEW_ISSUE_ERROR;
    }

    private void flushHeadEarly() {
        if (!this.featureManager.isEnabled("com.atlassian.plugins.issuenav.SEND_HEAD_EARLY.disabled") && !this.featureManager.isEnabled((Feature)IssueNavFeatures.FLUSH_HEAD_EARLY_OFF)) {
            this.flushHeadEarlyUtils.enable();
            PageBuilder pageBuilder = this.jiraPageBuilderService.get();
            Decorator decorator = this.getDecorator(this.jiraPageBuilderService);
            pageBuilder.setDecorator(decorator);
            pageBuilder.flush();
        }
    }

    private boolean isInlineEditEnabled() {
        return this.actionUtilsService.isInlineEditEnabled();
    }

    @VisibleForTesting
    Decorator getDecorator(JiraPageBuilderService jiraPageBuilderService) {
        return new GeneralJspDecorator(jiraPageBuilderService.assembler());
    }

    private void requireResources(Optional<Project> project) {
        if (project.isPresent()) {
            this.jiraPageBuilderService.assembler().resources().requirePage("com.atlassian.jira.jira-projects-issue-navigator:" + project.get().getProjectTypeKey().getKey() + "-project-navigator-page");
        } else {
            this.jiraPageBuilderService.assembler().resources().requireContext(BROWSE_CONTEXT).requireContext(PROJECT_ISSUE_NAVIGATOR_CONTEXT).requireContext(JIRA_VIEW_ISSUE_CONTEXT);
        }
        this.keyboardShortcutManager.requireShortcutsForContext(KeyboardShortcutManager.Context.issuenavigation);
        this.keyboardShortcutManager.requireShortcutsForContext(KeyboardShortcutManager.Context.issueaction);
    }

    public void setIssueKey(String issueKey) {
        this.issueKey = Optional.of(issueKey);
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = Optional.of(projectKey);
    }

    public void setFilter(String filter) {
        this.filter = Optional.of(filter);
    }

    public void setOrderby(String orderby) {
        this.orderby = Optional.of(orderby);
    }

    @ActionViewData
    public IssueWebPanelsBean getPanels() {
        return this.viewIssueData.panels;
    }

    @ActionViewData
    public IssueBean getIssue() {
        return this.viewIssueData.issue;
    }

    @ActionViewData
    public boolean getShowCollapse() {
        return this.viewIssueData.showCollapse;
    }

    @ActionViewData
    public String getSidebarContent() {
        return this.projectSidebarRenderer.render(this.project.get(), ISSUE_PROJECT_NAVIGATOR_SIDEBAR_KEY);
    }

    @ActionViewData
    public String getWindowTitle() {
        return this.title;
    }

    @ActionViewData
    public String getContactAdminLink() {
        return this.contactHelper.getAdministratorContactLinkHtml(JiraUrl.constructBaseUrl((HttpServletRequest)this.getHttpRequest()), this.jiraAuthenticationContext.getI18nHelper());
    }

    private static final class ViewIssueData {
        IssueWebPanelsBean panels;
        IssueBean issue;
        boolean showCollapse;

        private ViewIssueData() {
        }
    }
}

