/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.issuenavigator.helpers;

import com.atlassian.jira.components.issueviewer.config.IssueNavFeatures;
import com.atlassian.jira.config.Feature;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.issuenav.service.issuetable.IssueTable;
import com.atlassian.jira.plugin.webresource.JiraWebResourceManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.projects.issuenavigator.IssueSearchDataProvider;
import com.atlassian.jira.projects.issuenavigator.SearchResultsDataProvider;
import com.atlassian.jira.projects.issuenavigator.emptystate.EmptyStatePanelRenderer;
import com.atlassian.jira.projects.issuenavigator.filter.Filter;
import com.atlassian.jira.projects.issuenavigator.helpers.FilterLoaderHelper;
import com.atlassian.jira.projects.issuenavigator.helpers.ProjectIssueNavigatorHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.json.JSONEscaper;
import com.atlassian.jira.web.pagebuilder.JiraPageBuilderService;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugins.rest.common.json.JaxbJsonMarshaller;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletResponse;

@Scanned
@Named
public class DefaultProjectIssueNavigatorHelper
implements ProjectIssueNavigatorHelper {
    private static final String CAN_CREATE_ISSUES_KEY = "com.atlassian.jira.jira-projects-issue-navigator:can-create-issues";
    private static final String EMPTY_STATE_HTML_KEY = "com.atlassian.jira.jira-projects-issue-navigator:empty-state-panel-html";
    private static final String PROJECT_KEY = "projectKey";
    private static final String PROJECT_TYPE = "projectType";
    private static final String PROJECT_ID = "projectId";
    private final JiraWebResourceManager jiraWebResourceManager;
    private final ApplicationProperties applicationProperties;
    private final FilterLoaderHelper filterLoaderHelper;
    private final EmptyStatePanelRenderer emptyStatePanelRenderer;
    private final JiraPageBuilderService jiraPageBuilderService;
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final FeatureManager featureManager;
    private final JaxbJsonMarshaller jaxbJsonMarshaller;
    private final IssueSearchDataProvider issueSearchDataProvider;
    private final SearchResultsDataProvider searchResultsDataProvider;
    private List<Filter> filters;

    @Inject
    public DefaultProjectIssueNavigatorHelper(JiraWebResourceManager jiraWebResourceManager, ApplicationProperties applicationProperties, FilterLoaderHelper filterLoaderHelper, EmptyStatePanelRenderer emptyStatePanelRenderer, JiraPageBuilderService jiraPageBuilderService, PermissionManager permissionManager, JiraAuthenticationContext jiraAuthenticationContext, FeatureManager featureManager, JaxbJsonMarshaller jaxbJsonMarshaller, IssueSearchDataProvider issueSearchDataProvider, SearchResultsDataProvider searchResultsDataProvider) {
        this.jiraWebResourceManager = jiraWebResourceManager;
        this.applicationProperties = applicationProperties;
        this.filterLoaderHelper = filterLoaderHelper;
        this.emptyStatePanelRenderer = emptyStatePanelRenderer;
        this.jiraPageBuilderService = jiraPageBuilderService;
        this.permissionManager = permissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.featureManager = featureManager;
        this.jaxbJsonMarshaller = jaxbJsonMarshaller;
        this.issueSearchDataProvider = issueSearchDataProvider;
        this.searchResultsDataProvider = searchResultsDataProvider;
    }

    private void loadCanCreateIssueData(Project project) {
        boolean canCreateIssue = this.permissionManager.hasPermission(ProjectPermissions.CREATE_ISSUES, project, this.jiraAuthenticationContext.getLoggedInUser());
        this.jiraPageBuilderService.assembler().data().requireData(CAN_CREATE_ISSUES_KEY, Boolean.valueOf(canCreateIssue));
    }

    @Override
    public void setMetadata(String key, String value) {
        this.jiraWebResourceManager.putMetadata(key, value);
    }

    @Override
    public void setUpResponse(HttpServletResponse httpServletResponse, Optional<Project> project) {
        this.setMetadata("viewissue-use-history-api", "false");
        this.setMetadata("jira-base-url", this.applicationProperties.getString("jira.baseurl"));
        httpServletResponse.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        project.ifPresent(projectObj -> {
            this.filters = this.filterLoaderHelper.loadGenericFilters((Project)projectObj);
            this.filterLoaderHelper.loadCustomFilters((Project)projectObj);
            this.loadCanCreateIssueData((Project)projectObj);
            Optional<String> emptyState = this.emptyStatePanelRenderer.renderEmptyStatePanels((Project)projectObj);
            emptyState.ifPresent(html -> this.jiraPageBuilderService.assembler().data().requireData(EMPTY_STATE_HTML_KEY, JSONEscaper.escape((String)html)));
            this.jiraPageBuilderService.assembler().data().requireData(PROJECT_ID, (Number)projectObj.getId());
            this.jiraPageBuilderService.assembler().data().requireData(PROJECT_KEY, projectObj.getKey());
        });
        project.map(Project::getProjectTypeKey).map(ProjectTypeKey::getKey).ifPresent(projectTypeKey -> this.jiraPageBuilderService.assembler().data().requireData(PROJECT_TYPE, projectTypeKey));
    }

    @Override
    public void embedSearchResults(Optional<Project> project, Optional<String> filter, Optional<String> orderBy, Optional<String> issueKey) {
        if (!this.featureManager.isEnabled((Feature)IssueNavFeatures.PROJECT_NAVIGATOR_WRM_DATA_OFF)) {
            BiConsumer<String, Object> wrmDataAssembler = (key, obj) -> this.jiraPageBuilderService.assembler().data().requireData(key, writer -> writer.write(this.jaxbJsonMarshaller.marshal(obj)));
            Optional<IssueTable> issueTable = this.issueSearchDataProvider.apply(this.filters, project.get(), filter, orderBy, wrmDataAssembler);
            issueTable.ifPresent(table -> this.searchResultsDataProvider.apply((IssueTable)table, issueKey, wrmDataAssembler));
        }
    }
}

