/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.issuenavigator.filter;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.issuenavigator.filter.Filter;
import com.atlassian.jira.projects.issuenavigator.filter.HasCurrentUserFunctionVisitor;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.clause.ClauseVisitor;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public class SearchRequestToFilterFunction
implements Function<SearchRequest, Filter> {
    private static final String ORDER_BY_CLAUSE = "ORDER BY";
    private static final String DEFAULT_ORDER_BY = "created DESC";
    private final Project project;
    private final SearchService searchService;

    public SearchRequestToFilterFunction(Project project, SearchService searchService) {
        this.project = project;
        this.searchService = searchService;
    }

    @Override
    public Filter apply(SearchRequest request) {
        Query query = request.getQuery();
        return Filter.builder(Long.toString(request.getId()), this.getJqlWithoutOrderBy(query), this.getOrderBy(query), this.stripProjectKeyFromFilterName(request)).requiresUser(this.hasCurrentUserFunction(query)).build();
    }

    private String getJqlWithoutOrderBy(Query query) {
        QueryImpl whereClauseOnlyQuery = new QueryImpl(query.getWhereClause(), null, null);
        return StringUtils.trim((String)String.format("%s %s {1}", this.searchService.getJqlString((Query)whereClauseOnlyQuery), ORDER_BY_CLAUSE));
    }

    private String getOrderBy(Query query) {
        QueryImpl orderByOnlyQuery = new QueryImpl(null, query.getOrderByClause(), null);
        String actualOrderBy = this.searchService.getJqlString((Query)orderByOnlyQuery);
        if (StringUtils.isBlank((CharSequence)actualOrderBy)) {
            return DEFAULT_ORDER_BY;
        }
        return StringUtils.trim((String)StringUtils.remove((String)actualOrderBy, (String)ORDER_BY_CLAUSE));
    }

    private String stripProjectKeyFromFilterName(SearchRequest request) {
        return StringUtils.trim((String)StringUtils.remove((String)request.getName(), (String)("(" + this.project.getKey() + ")")));
    }

    private boolean hasCurrentUserFunction(Query query) {
        if (query.getWhereClause() == null) {
            return false;
        }
        HasCurrentUserFunctionVisitor visitor = new HasCurrentUserFunctionVisitor();
        query.getWhereClause().accept((ClauseVisitor)visitor);
        return visitor.hasCurrentUserFunction();
    }
}

