/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.issuenavigator.filter;

import com.atlassian.jira.projects.issuenavigator.filter.Filter;
import com.google.common.base.Joiner;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;

public class RemoveNonSearchableFieldsFromOrderByFunction
implements Function<Filter, Filter> {
    private final List<String> searchableFieldNames;

    public RemoveNonSearchableFieldsFromOrderByFunction(List<String> searchableFieldNames) {
        this.searchableFieldNames = searchableFieldNames;
    }

    @Override
    public Filter apply(Filter filter) {
        String orderby = filter.getDefaultOrderby();
        LinkedList<String> orderByClauses = new LinkedList<String>();
        Matcher m = Filter.ORDERBY_PATTERN.matcher(orderby);
        while (m.find()) {
            if (!this.searchableFieldNames.contains(m.group(2))) continue;
            orderByClauses.add(m.group(1));
        }
        return Filter.builder(filter).defaultOrderby(Joiner.on((String)", ").join(orderByClauses)).build();
    }
}

