/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.issuenavigator.emptystate;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.projecttemplates.service.ProjectTemplateService;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.Condition;
import java.util.Map;
import java.util.Optional;

@Scanned
public class WasProjectCreatedWithTemplateCondition
implements Condition {
    private String projectTemplateKey;
    private final ProjectTemplateService projectTemplateService;

    public WasProjectCreatedWithTemplateCondition(@ComponentImport ProjectTemplateService projectTemplateService) {
        this.projectTemplateService = projectTemplateService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
        Optional<String> projectTemplateKey = Optional.ofNullable(params.get("projectTemplateKey"));
        if (!projectTemplateKey.isPresent()) {
            throw new PluginParseException("Please provide a 'projectTemplateKey' parameter.");
        }
        this.projectTemplateKey = projectTemplateKey.get();
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        Optional<Project> projectParam = Optional.ofNullable((Project)context.get("project"));
        return projectParam.map(project -> {
            Optional appliedTemplate = this.projectTemplateService.getAppliedProjectTemplateKey(project.getId());
            return appliedTemplate.map(template -> this.projectTemplateKey.equals(template.getKey())).orElse(false);
        }).orElse(false);
    }
}

