/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.issuenavigator.conditions;

import com.atlassian.jira.application.ApplicationAuthorizationService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;
import java.util.Optional;

public class IsCollaboratorInServiceDeskOrNotServiceDeskProjectCondition
implements Condition {
    private static final String PROJECT_CONTEXT_KEY = "project";
    private static final String IS_AGENT_CONTEXT_KEY = "isAgent";
    private static final String SERVICE_DESK_TYPE_KEY = "service_desk";
    private ApplicationAuthorizationService applicationAuthorizationService;

    public IsCollaboratorInServiceDeskOrNotServiceDeskProjectCondition(ApplicationAuthorizationService applicationAuthorizationService) {
        this.applicationAuthorizationService = applicationAuthorizationService;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        return !this.isServiceDeskProject(context) || this.isCollaboratorInServiceDesk(context);
    }

    private boolean isServiceDeskProject(Map<String, Object> context) {
        if (this.applicationAuthorizationService.rolesEnabled() && context.containsKey(PROJECT_CONTEXT_KEY)) {
            Project project = (Project)context.get(PROJECT_CONTEXT_KEY);
            Optional<ProjectTypeKey> type = Optional.ofNullable(project.getProjectTypeKey());
            return type.map(projectTypeKey -> projectTypeKey.getKey().equals(SERVICE_DESK_TYPE_KEY)).orElse(false);
        }
        return false;
    }

    private boolean isCollaboratorInServiceDesk(Map<String, Object> context) {
        if (context.containsKey(IS_AGENT_CONTEXT_KEY)) {
            boolean isAgentInServiceDesk = (Boolean)context.get(IS_AGENT_CONTEXT_KEY);
            return !isAgentInServiceDesk;
        }
        return true;
    }
}

