/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.issuenavigator;

import com.atlassian.jira.plugin.issuenav.rest.IssueTableResource;
import com.atlassian.jira.plugin.issuenav.service.StableSearchResultBean;
import com.atlassian.jira.plugin.issuenav.service.issuetable.IssueTable;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Named
public class SearchResultsDataProvider {
    private static final String SEARCH_RESULTS_DATA_KEY = "com.atlassian.jira.jira-issue-navigator-components:search-results";
    private final IssueTableResource issueTableResource;

    @Inject
    public SearchResultsDataProvider(@ComponentImport IssueTableResource issueTableResource) {
        this.issueTableResource = issueTableResource;
    }

    public void apply(IssueTable issueTable, Optional<String> issueKey, BiConsumer<String, Object> dataConsumer) {
        List allIssueIds = issueTable.getIssueIds();
        if (allIssueIds.size() == 0) {
            return;
        }
        int pageSize = issueTable.getPageSize();
        int page = issueKey.map(key -> issueTable.getIssueKeys().indexOf(key)).filter(i -> i >= 0).map(i -> i / pageSize).orElse(0);
        int fromIndex = page * pageSize;
        List pageIssueIds = allIssueIds.subList(fromIndex, Math.min(fromIndex + pageSize, allIssueIds.size()));
        Response response = this.issueTableResource.getIssueTableHtml(pageIssueIds, null, null, "split-view", null, null);
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            SearchResultData data = new SearchResultData();
            data.ids = pageIssueIds;
            data.response = (StableSearchResultBean)response.getEntity();
            dataConsumer.accept(SEARCH_RESULTS_DATA_KEY, data);
        }
    }

    @XmlRootElement
    public static class SearchResultData {
        @XmlElement
        StableSearchResultBean response;
        @XmlElement
        List<Long> ids;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SearchResultData that = (SearchResultData)o;
            return Objects.equals(this.response, that.response) && Objects.equals(this.ids, that.ids);
        }

        public int hashCode() {
            return Objects.hash(this.response, this.ids);
        }
    }
}

