/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.issuenavigator;

import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.jira.components.issueviewer.config.IssueNavFeatures;
import com.atlassian.jira.config.Feature;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.sun.jersey.api.uri.UriTemplate;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Scanned
public class ProjectIssueViewRewriteFilter
extends AbstractHttpFilter {
    public static final Pattern BROWSE_URL_PATTERN = Pattern.compile("^/browse/([^/]+-[0-9]+)(?:\\?(.*))?");
    private final IssueManager issueManager;
    private final FeatureManager featureManager;
    private UriTemplate to;

    public ProjectIssueViewRewriteFilter(@ComponentImport IssueManager issueManager, @ComponentImport FeatureManager featureManager) {
        this.issueManager = issueManager;
        this.featureManager = featureManager;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.to = Optional.ofNullable(filterConfig.getInitParameter("to")).map(UriTemplate::new).orElseThrow(IllegalArgumentException::new);
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.featureManager.isEnabled((Feature)IssueNavFeatures.REDIRECT_FROM_GLOBAL_TO_PROJECT_OFF)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String contextPath = request.getContextPath();
        String requestURI = request.getRequestURI();
        requestURI = requestURI.substring(contextPath.length());
        Optional<Matcher> matcher = Optional.of(BROWSE_URL_PATTERN.matcher(requestURI)).filter(Matcher::find);
        Optional<String> issueKey = matcher.map(m -> m.group(1));
        Optional<String> queryString = matcher.map(m -> m.group(2));
        Optional<MutableIssue> issue = issueKey.map(String::toUpperCase).map(arg_0 -> ((IssueManager)this.issueManager).getIssueObject(arg_0));
        Optional<Project> project = issue.map(Issue::getProjectObject);
        Optional<String> projectKey = project.map(Project::getKey);
        if (projectKey.isPresent() && !Objects.equals(issueKey.get(), issue.get().getKey())) {
            response.sendRedirect(request.getContextPath() + "/browse/" + issue.get().getKey() + queryString.map(s -> "?" + s).orElse(""));
            return;
        }
        if (issueKey.isPresent()) {
            MapBuilder variables = MapBuilder.newBuilder((Object)"project-key", (Object)projectKey.orElse("")).add((Object)"issue-key", (Object)issueKey.get()).add((Object)"query", (Object)queryString.map(string -> "&" + string).orElse(""));
            request.setAttribute("isViewIssue", (Object)true);
            String targetUrl = this.to.createURI(variables.toMap());
            request.getRequestDispatcher(targetUrl).forward((ServletRequest)request, (ServletResponse)response);
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }
}

