/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.issuenavigator;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.bc.filter.ProjectSearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.components.issueviewer.config.IssueNavFeatures;
import com.atlassian.jira.config.Feature;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.issuenav.service.issuetable.IssueTable;
import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcutManager;
import com.atlassian.jira.plugin.webresource.JiraWebResourceManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.projects.api.service.FlushHeadEarlyUtils;
import com.atlassian.jira.projects.issuenavigator.IssueRenderService;
import com.atlassian.jira.projects.issuenavigator.IssueSearchDataProvider;
import com.atlassian.jira.projects.issuenavigator.SearchResultsDataProvider;
import com.atlassian.jira.projects.issuenavigator.emptystate.EmptyStatePanelRenderer;
import com.atlassian.jira.projects.issuenavigator.filter.AllFieldsInOrderByClause;
import com.atlassian.jira.projects.issuenavigator.filter.Filter;
import com.atlassian.jira.projects.issuenavigator.filter.GenericFilters;
import com.atlassian.jira.projects.issuenavigator.filter.LoggedInPredicate;
import com.atlassian.jira.projects.issuenavigator.filter.RemoveNonSearchableFieldsFromOrderByFunction;
import com.atlassian.jira.projects.issuenavigator.filter.SearchRequestToFilterFunction;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.json.JSONEscaper;
import com.atlassian.jira.web.HttpServletVariables;
import com.atlassian.jira.web.pagebuilder.JiraPageBuilderService;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.plugins.rest.common.json.JaxbJsonMarshaller;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.webresource.api.assembler.RequiredData;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;

@Scanned
@Named
public class PageContextProvider
implements ContextProvider {
    private static final String SIDEBAR_ISSUE_VIEW_ITEM = "com.atlassian.jira.jira-projects-issue-navigator:sidebar-issue-view";
    private static final String PROJECT = "project";
    static final String CAN_MANAGE_FILTERS_KEY = "com.atlassian.jira.jira-projects-issue-navigator:can-manage-filters";
    static final String CAN_CREATE_ISSUES_KEY = "com.atlassian.jira.jira-projects-issue-navigator:can-create-issues";
    static final String PROJECT_FILTERS_KEY = "com.atlassian.jira.jira-projects-issue-navigator:project-filters";
    static final String EMPTY_STATE_HTML_KEY = "com.atlassian.jira.jira-projects-issue-navigator:empty-state-panel-html";
    static final String GENERIC_FILTERS_KEY = "com.atlassian.jira.jira-projects-issue-navigator:generic-filters";
    static final String DEFAULT_FILTER_PRIORITY_KEY = "com.atlassian.jira.jira-projects-issue-navigator:default-filter-priority";
    private static final String PROJECT_KEY = "projectKey";
    private static final String PROJECT_TYPE = "projectType";
    private static final String PROJECT_ID = "projectId";
    static final String SERVER_RENDERED_ISSUE_KEY = "com.atlassian.jira.jira-projects-issue-navigator:server-rendered";
    public static final Set<String> DEFAULT_FILTER_PRIORITY = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("allopenissues", "allissues")));
    public static final String PROJECT_ISSUE_NAVIGATOR_CONTEXT = "project.issue.navigator";
    public static final String JIRA_VIEW_ISSUE_CONTEXT = "jira.view.issue";
    private final Set<String> filterFields;
    private final JiraAuthenticationContext authenticationContext;
    private final JiraWebResourceManager jiraWebResourceManager;
    private final JiraPageBuilderService jiraPageBuilderService;
    private final KeyboardShortcutManager keyboardShortcutManager;
    private final JaxbJsonMarshaller jaxbJsonMarshaller;
    private final ProjectSearchRequestService projectSearchRequestService;
    private final SearchService searchService;
    private final PermissionManager permissionManager;
    private final GenericFilters genericFilters;
    private final I18nResolver i18nResolver;
    private final EmptyStatePanelRenderer emptyStatePanelRenderer;
    private final FieldLayoutManager fieldLayoutManager;
    private final FieldManager fieldManager;
    private final IssueSearchDataProvider issueSearchDataProvider;
    private final SearchResultsDataProvider searchResultsDataProvider;
    private final IssueRenderService issueRenderService;
    private final HttpServletVariables httpServletVariables;
    private final FeatureManager featureManager;
    private final FlushHeadEarlyUtils flushHeadEarlyUtils;
    private final ApplicationProperties applicationProperties;

    @Inject
    public PageContextProvider(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport JiraPageBuilderService jiraPageBuilderService, @ComponentImport JiraWebResourceManager jiraWebResourceManager, @ComponentImport KeyboardShortcutManager keyboardShortcutManager, @ComponentImport JaxbJsonMarshaller jaxbJsonMarshaller, @ComponentImport ProjectSearchRequestService projectSearchRequestService, @ComponentImport SearchService searchService, @ComponentImport PermissionManager permissionManager, @ComponentImport FieldLayoutManager fieldLayoutManager, @ComponentImport FieldManager fieldManager, GenericFilters genericFilters, @ComponentImport I18nResolver i18nResolver, EmptyStatePanelRenderer emptyStatePanelRenderer, IssueSearchDataProvider issueSearchDataProvider, SearchResultsDataProvider searchResultsDataProvider, IssueRenderService issueRenderService, @ComponentImport HttpServletVariables httpServletVariables, @ComponentImport FeatureManager featureManager, @ComponentImport FlushHeadEarlyUtils flushHeadEarlyUtils, @ComponentImport ApplicationProperties applicationProperties) {
        this.authenticationContext = authenticationContext;
        this.jiraWebResourceManager = jiraWebResourceManager;
        this.jiraPageBuilderService = jiraPageBuilderService;
        this.keyboardShortcutManager = keyboardShortcutManager;
        this.jaxbJsonMarshaller = jaxbJsonMarshaller;
        this.projectSearchRequestService = projectSearchRequestService;
        this.searchService = searchService;
        this.permissionManager = permissionManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.fieldManager = fieldManager;
        this.genericFilters = genericFilters;
        this.i18nResolver = i18nResolver;
        this.emptyStatePanelRenderer = emptyStatePanelRenderer;
        this.issueSearchDataProvider = issueSearchDataProvider;
        this.searchResultsDataProvider = searchResultsDataProvider;
        this.issueRenderService = issueRenderService;
        this.httpServletVariables = httpServletVariables;
        this.featureManager = featureManager;
        this.flushHeadEarlyUtils = flushHeadEarlyUtils;
        this.applicationProperties = applicationProperties;
        this.filterFields = Collections.unmodifiableSet(((Map)genericFilters.get()).values().stream().flatMap(x -> Stream.concat(Stream.of(x.getFields()), AllFieldsInOrderByClause.get(x).stream())).collect(Collectors.toSet()));
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        this.jiraWebResourceManager.putMetadata("viewissue-use-history-api", "false");
        this.jiraWebResourceManager.putMetadata("jira-base-url", this.applicationProperties.getString("jira.baseurl"));
        this.httpServletVariables.getHttpResponse().setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        if (!this.flushHeadEarlyUtils.isEnabled()) {
            this.jiraPageBuilderService.assembler().resources().requireContext(PROJECT_ISSUE_NAVIGATOR_CONTEXT);
            this.jiraPageBuilderService.assembler().resources().requireContext(JIRA_VIEW_ISSUE_CONTEXT);
        }
        this.keyboardShortcutManager.requireShortcutsForContext(KeyboardShortcutManager.Context.issuenavigation);
        this.keyboardShortcutManager.requireShortcutsForContext(KeyboardShortcutManager.Context.issueaction);
        Optional<Project> optionalProject = Optional.ofNullable((Project)context.get(PROJECT));
        HttpServletRequest httpRequest = this.httpServletVariables.getHttpRequest();
        optionalProject.ifPresent(project -> {
            List<Filter> filters = this.loadGenericFilters((Project)project);
            Optional<String> issueKey = PageContextProvider.extractIssueKeyFromRequest(httpRequest);
            boolean isViewIssue = PageContextProvider.extractIssueViewFlagFromRequest(httpRequest);
            if (!(isViewIssue && httpRequest.getAttribute("filter") == null || this.featureManager.isEnabled((Feature)IssueNavFeatures.PROJECT_NAVIGATOR_WRM_DATA_OFF))) {
                BiConsumer<String, Object> wrmDataAssembler = (key, obj) -> this.jiraPageBuilderService.assembler().data().requireData(key, writer -> writer.write(this.jaxbJsonMarshaller.marshal(obj)));
                Optional<IssueTable> issueTable = this.issueSearchDataProvider.apply(filters, (Project)project, Optional.ofNullable(httpRequest.getAttribute("filter")).map(String::valueOf), Optional.ofNullable(httpRequest.getAttribute("orderby")).map(String::valueOf), wrmDataAssembler);
                issueTable.ifPresent(table -> this.searchResultsDataProvider.apply((IssueTable)table, issueKey, wrmDataAssembler));
            }
            if (isViewIssue) {
                issueKey.ifPresent(key -> {
                    if (httpRequest.getAttribute("filter") != null) {
                        context.put("showCollapse", true);
                    }
                    this.issueRenderService.render((String)key, context::put);
                    context.put("template", "view");
                    this.jiraPageBuilderService.assembler().data().requireData(SERVER_RENDERED_ISSUE_KEY, Boolean.valueOf(true));
                });
            }
            this.loadCustomFilters((Project)project);
            this.loadCanCreateIssueData((Project)project);
            Optional<String> emptyState = this.emptyStatePanelRenderer.renderEmptyStatePanels((Project)project);
            emptyState.ifPresent(html -> this.jiraPageBuilderService.assembler().data().requireData(EMPTY_STATE_HTML_KEY, JSONEscaper.escape((String)html)));
            this.jiraPageBuilderService.assembler().data().requireData(PROJECT_ID, (Number)project.getId());
            this.jiraPageBuilderService.assembler().data().requireData(PROJECT_KEY, project.getKey());
            ProjectTypeKey projectTypeKey = project.getProjectTypeKey();
            this.jiraPageBuilderService.assembler().data().requireData(PROJECT_TYPE, projectTypeKey == null ? "" : projectTypeKey.getKey());
        });
        return ImmutableMap.copyOf(context);
    }

    private static boolean extractIssueViewFlagFromRequest(HttpServletRequest httpRequest) {
        return Optional.of("isViewIssue").map(arg_0 -> ((HttpServletRequest)httpRequest).getAttribute(arg_0)).filter(Boolean.TRUE::equals).isPresent();
    }

    private static Optional<String> extractIssueKeyFromRequest(HttpServletRequest httpRequest) {
        return Optional.of("issueKey").map(arg_0 -> ((HttpServletRequest)httpRequest).getAttribute(arg_0)).map(String::valueOf);
    }

    private List<Filter> loadGenericFilters(Project project) {
        Set projectFieldLayouts = this.fieldLayoutManager.getUniqueFieldLayouts(project);
        Set userFieldLayouts = this.fieldManager.getVisibleFieldLayouts(this.authenticationContext.getLoggedInUser());
        Sets.SetView fieldLayouts = Sets.intersection((Set)projectFieldLayouts, (Set)userFieldLayouts);
        List<String> searchableFieldNames = this.filterFields.stream().map(fieldId -> Optional.ofNullable(this.fieldManager.getField(fieldId)).orElseThrow(() -> new RuntimeException("FieldManager can't find field \"" + fieldId + "\""))).filter(arg_0 -> this.lambda$loadGenericFilters$9((Set)fieldLayouts, arg_0)).map(Field::getId).collect(Collectors.toList());
        List<Filter> genericFilters = ((Map)this.genericFilters.get()).values().stream().filter(x -> searchableFieldNames.containsAll(Arrays.asList(x.getFields()))).filter(new LoggedInPredicate<Filter>(this.authenticationContext.isLoggedInUser(), Filter::isRequiresUser)).map(new RemoveNonSearchableFieldsFromOrderByFunction(searchableFieldNames)).map(x -> Filter.builder(x).label(this.i18nResolver.getText(x.getLabel())).build()).collect(Collectors.toList());
        RequiredData wrmData = this.jiraPageBuilderService.assembler().data();
        wrmData.requireData(GENERIC_FILTERS_KEY, writer -> writer.write(this.jaxbJsonMarshaller.marshal((Object)genericFilters)));
        wrmData.requireData(DEFAULT_FILTER_PRIORITY_KEY, writer -> writer.append(this.jaxbJsonMarshaller.marshal(DEFAULT_FILTER_PRIORITY)));
        return genericFilters;
    }

    private void loadCustomFilters(Project project) {
        List searchRequests = this.projectSearchRequestService.getSearchRequestsForProject(this.authenticationContext.getLoggedInUser(), project);
        List filters = (List)searchRequests.stream().map(new SearchRequestToFilterFunction(project, this.searchService)).filter(new LoggedInPredicate<Filter>(this.authenticationContext.isLoggedInUser(), Filter::isRequiresUser)).collect(CollectorsUtil.toImmutableList());
        boolean ownsAnySearchRequest = searchRequests.stream().anyMatch(request -> request.getOwner().equals((Object)this.authenticationContext.getLoggedInUser()));
        this.jiraPageBuilderService.assembler().data().requireData(CAN_MANAGE_FILTERS_KEY, Boolean.valueOf(ownsAnySearchRequest));
        this.jiraPageBuilderService.assembler().data().requireData(PROJECT_FILTERS_KEY, writer -> writer.append(this.jaxbJsonMarshaller.marshal((Object)filters)));
    }

    private void loadCanCreateIssueData(Project project) {
        boolean canCreateIssue = this.permissionManager.hasPermission(ProjectPermissions.CREATE_ISSUES, project, this.authenticationContext.getLoggedInUser());
        this.jiraPageBuilderService.assembler().data().requireData(CAN_CREATE_ISSUES_KEY, Boolean.valueOf(canCreateIssue));
    }

    private /* synthetic */ boolean lambda$loadGenericFilters$9(Set fieldLayouts, Field x) {
        return !this.fieldManager.isFieldHidden(fieldLayouts, x);
    }
}

