/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.issuenavigator;

import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.components.issueviewer.action.IssueBean;
import com.atlassian.jira.components.issueviewer.service.SessionSearchService;
import com.atlassian.jira.components.issueviewer.viewissue.webpanel.IssueWebPanelsBean;
import com.atlassian.jira.components.issueviewer.viewissue.webpanel.WebPanelMapperUtil;
import com.atlassian.jira.event.mau.MauEventService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.plugin.webresource.JiraWebResourceManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.issuenavigator.IssueRenderService;
import com.atlassian.jira.rest.v2.issue.OpsbarBean;
import com.atlassian.jira.rest.v2.issue.builder.BeanBuilderFactory;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.jira.web.action.issue.IssueMetadataHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.inject.Inject;
import javax.inject.Named;
import webwork.action.Action;

@Named
public class DefaultIssueRenderService
implements IssueRenderService {
    private final IssueService issueService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final BeanBuilderFactory beanBuilderFactory;
    private final IssueMetadataHelper issueMetadataHelper;
    private final SessionSearchService sessionSearchService;
    private final WebPanelMapperUtil webPanelMapperUtil;
    private final GlobalPermissionManager globalPermissionManager;
    private final UserProjectHistoryManager userProjectHistoryManager;
    private final JiraWebResourceManager jiraWebResourceManager;
    private final UserIssueHistoryManager userIssueHistoryManager;
    private final MauEventService mauEventService;

    @Inject
    public DefaultIssueRenderService(@ComponentImport IssueService issueService, JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport BeanBuilderFactory beanBuilderFactory, @ComponentImport IssueMetadataHelper issueMetadataHelper, @ComponentImport SessionSearchService sessionSearchService, @ComponentImport WebPanelMapperUtil webPanelMapperUtil, @ComponentImport GlobalPermissionManager globalPermissionManager, @ComponentImport UserProjectHistoryManager userProjectHistoryManager, JiraWebResourceManager jiraWebResourceManager, @ComponentImport UserIssueHistoryManager userIssueHistoryManager, @ComponentImport MauEventService mauEventService) {
        this.issueService = issueService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.beanBuilderFactory = beanBuilderFactory;
        this.issueMetadataHelper = issueMetadataHelper;
        this.sessionSearchService = sessionSearchService;
        this.webPanelMapperUtil = webPanelMapperUtil;
        this.globalPermissionManager = globalPermissionManager;
        this.userProjectHistoryManager = userProjectHistoryManager;
        this.jiraWebResourceManager = jiraWebResourceManager;
        this.userIssueHistoryManager = userIssueHistoryManager;
        this.mauEventService = mauEventService;
    }

    private void tagMauEventWithProject(Project project) {
        this.mauEventService.setApplicationForThreadBasedOnProject(project);
    }

    @Override
    public ServiceResult render(String key, BiConsumer<String, Object> dataConsumer) {
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
        IssueService.IssueResult issueResult = this.issueService.getIssue(loggedInUser, key);
        if (!issueResult.isValid()) {
            return issueResult;
        }
        MutableIssue issue = issueResult.getIssue();
        Project projectObject = issue.getProjectObject();
        this.tagMauEventWithProject(projectObject);
        OpsbarBean opsbarBean = this.beanBuilderFactory.newOpsbarBeanBuilder((Issue)issue).build();
        Map metadata = this.issueMetadataHelper.getMetadata((Issue)issue, this.sessionSearchService.getSessionSearch());
        boolean isEditable = this.issueService.isEditable((Issue)issue, loggedInUser);
        IssueBean issueBean = new IssueBean((Issue)issue, metadata, opsbarBean, projectObject, issue.getStatusObject(), null, true, isEditable);
        IssueWebPanelsBean panels = this.webPanelMapperUtil.create((Issue)issue, (Action)new FakeAction(this.jiraAuthenticationContext, this.globalPermissionManager));
        this.userIssueHistoryManager.addIssueToHistory(loggedInUser, (Issue)issue);
        for (Map.Entry entry : metadata.entrySet()) {
            this.jiraWebResourceManager.putMetadata((String)entry.getKey(), (String)entry.getValue());
        }
        this.jiraWebResourceManager.putMetadata("server-view-issue-is-editable", Boolean.toString(isEditable));
        dataConsumer.accept("panels", panels);
        dataConsumer.accept("issue", issueBean);
        return ServiceOutcomeImpl.ok((Object)true);
    }

    public static class FakeAction
    implements Action,
    OperationContext {
        private final Map<String, Object> fieldValuesHolder = new HashMap<String, Object>();
        private final JiraAuthenticationContext jiraAuthenticationContext;
        private final GlobalPermissionManager globalPermissionManager;

        public FakeAction(JiraAuthenticationContext jiraAuthenticationContext, GlobalPermissionManager globalPermissionManager) {
            this.jiraAuthenticationContext = jiraAuthenticationContext;
            this.globalPermissionManager = globalPermissionManager;
        }

        public String execute() throws Exception {
            return null;
        }

        public Map<String, Object> getFieldValuesHolder() {
            return this.fieldValuesHolder;
        }

        public IssueOperation getIssueOperation() {
            return IssueOperations.VIEW_ISSUE_OPERATION;
        }

        public Map<String, String> getErrors() {
            return Collections.emptyMap();
        }

        public String getText(String key) {
            return this.jiraAuthenticationContext.getI18nHelper().getText(key);
        }

        public boolean hasGlobalPermission(String key) {
            return this.globalPermissionManager.hasPermission(GlobalPermissionKey.of((String)key), this.jiraAuthenticationContext.getLoggedInUser());
        }
    }
}

