/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.issuenavigator;

import com.atlassian.fugue.Option;
import com.atlassian.jira.projects.legacy.LegacyBrowseProjectUrlComponents;
import com.atlassian.jira.projects.legacy.LegacyBrowseProjectUrlTransformer;
import com.atlassian.jira.util.UrlBuilder;

public class AllProjectsIssuesUrlTransformer
implements LegacyBrowseProjectUrlTransformer {
    public Option<String> getTransformedUrl(LegacyBrowseProjectUrlComponents legacyUrlComponents) {
        if (this.canTransformLegacyUrl(legacyUrlComponents)) {
            return Option.some((Object)this.buildProjectCentricNavUrl(legacyUrlComponents));
        }
        return Option.none();
    }

    private boolean canTransformLegacyUrl(LegacyBrowseProjectUrlComponents legacyUrlComponents) {
        return this.isGoingToAllIssues((Option<String>)legacyUrlComponents.getSelectedTab());
    }

    private String buildProjectCentricNavUrl(LegacyBrowseProjectUrlComponents legacyUrlComponents) {
        String contextPath = legacyUrlComponents.getContextPath();
        String projectKey = legacyUrlComponents.getProjectKey();
        UrlBuilder url = new UrlBuilder(contextPath, false);
        url.addPath("projects").addPath(projectKey).addPath("issues");
        return url.asUrlString();
    }

    private boolean isGoingToAllIssues(Option<String> selectedProjectTab) {
        return selectedProjectTab.isDefined() && ((String)selectedProjectTab.get()).endsWith("issues-panel");
    }
}

