/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.url;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugins.webhooks.url.IssueContextSerializer;
import com.atlassian.jira.plugins.webhooks.url.ProjectContextSerializer;
import com.atlassian.jira.project.Project;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueAndProjectContextSerializer {
    private final IssueContextSerializer issueContextSerializer;
    private final ProjectContextSerializer projectContextSerializer;

    @Autowired
    public IssueAndProjectContextSerializer(IssueContextSerializer issueContextSerializer, ProjectContextSerializer projectContextSerializer) {
        this.issueContextSerializer = issueContextSerializer;
        this.projectContextSerializer = projectContextSerializer;
    }

    public Map<String, Object> getContext(Project project, Issue issue) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(this.issueContextSerializer.getContext(issue));
        builder.putAll(this.projectContextSerializer.getContext(project));
        return builder.build();
    }
}

