/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.serializer;

import com.atlassian.jira.event.issue.IssuePreDeleteEvent;
import com.atlassian.jira.issue.fields.rest.json.UserBeanFactory;
import com.atlassian.jira.plugins.webhooks.registration.RegisteredWebHookEventFactory;
import com.atlassian.jira.plugins.webhooks.serializer.AbstractIssueEventSerializer;
import com.atlassian.jira.plugins.webhooks.serializer.IssueBeanFactory;
import com.google.common.collect.ImmutableMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssuePreDeleteEventSerializer
extends AbstractIssueEventSerializer<IssuePreDeleteEvent> {
    private final UserBeanFactory userBeanFactory;
    private final IssueBeanFactory issueBeanFactory;

    @Autowired
    public IssuePreDeleteEventSerializer(RegisteredWebHookEventFactory registeredWebHookEventFactory, UserBeanFactory userBeanFactory, IssueBeanFactory issueBeanFactory) {
        super(registeredWebHookEventFactory);
        this.userBeanFactory = userBeanFactory;
        this.issueBeanFactory = issueBeanFactory;
    }

    @Override
    protected ImmutableMap.Builder<String, Object> putFields(IssuePreDeleteEvent preDeleteEvent, ImmutableMap.Builder<String, Object> builder) {
        if (preDeleteEvent.getUser() != null) {
            builder.put((Object)"user", (Object)this.userBeanFactory.createBean(preDeleteEvent.getUser()));
        }
        builder.put((Object)"issue", (Object)this.issueBeanFactory.createBean(preDeleteEvent.getIssue()));
        return builder;
    }
}

