/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.serializer;

import com.atlassian.jira.event.issue.link.IssueLinkCreatedEvent;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.plugins.webhooks.registration.RegisteredWebHookEventFactory;
import com.atlassian.jira.plugins.webhooks.serializer.AbstractJiraEventSerializer;
import com.atlassian.jira.plugins.webhooks.serializer.bean.IssueLinkBean;
import com.atlassian.jira.plugins.webhooks.serializer.bean.IssueLinkTypeBean;
import com.google.common.collect.ImmutableMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueLinkCreatedEventSerializer
extends AbstractJiraEventSerializer<IssueLinkCreatedEvent> {
    @Autowired
    public IssueLinkCreatedEventSerializer(RegisteredWebHookEventFactory registeredWebHookEventFactory) {
        super(registeredWebHookEventFactory);
    }

    @Override
    protected Long getTimestamp(IssueLinkCreatedEvent event) {
        return event.getEventCreation().toEpochMilli();
    }

    @Override
    protected ImmutableMap.Builder<String, Object> putFields(IssueLinkCreatedEvent event, ImmutableMap.Builder<String, Object> defaultJson) {
        IssueLink link = event.getIssueLink();
        return defaultJson.put((Object)"issueLink", (Object)new IssueLinkBean(link.getId(), link.getSourceId(), link.getDestinationId(), new IssueLinkTypeBean(link.getIssueLinkType()), link.getSequence(), link.isSystemLink()));
    }
}

