/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.serializer;

import com.atlassian.jira.plugins.webhooks.registration.RegisteredWebHookEventFactory;
import com.atlassian.jira.plugins.webhooks.serializer.JacksonSerializer;
import com.atlassian.webhooks.api.register.RegisteredWebHookEvent;
import com.atlassian.webhooks.api.register.listener.WebHookListener;
import com.atlassian.webhooks.spi.EventSerializer;
import com.google.common.collect.ImmutableMap;

public abstract class AbstractJiraEventSerializer<T>
implements EventSerializer<T> {
    private final RegisteredWebHookEventFactory registeredWebHookEventFactory;

    protected AbstractJiraEventSerializer(RegisteredWebHookEventFactory registeredWebHookEventFactory) {
        this.registeredWebHookEventFactory = registeredWebHookEventFactory;
    }

    protected ImmutableMap.Builder<String, Object> defaultFields(T event) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"timestamp", (Object)this.getTimestamp(event));
        builder.put((Object)"webhookEvent", (Object)this.resolveEventName(event));
        return builder;
    }

    protected abstract Long getTimestamp(T var1);

    public final String serialize(T event) {
        return JacksonSerializer.serialize(this.putFields(event, this.defaultFields(event)).build());
    }

    protected abstract ImmutableMap.Builder<String, Object> putFields(T var1, ImmutableMap.Builder<String, Object> var2);

    private String resolveEventName(T event) {
        return this.getJiraEventMapping(event).getId();
    }

    private RegisteredWebHookEvent getJiraEventMapping(T e) {
        for (RegisteredWebHookEvent registeredWebHookEvent : this.registeredWebHookEventFactory.getAllEvents()) {
            if (!registeredWebHookEvent.getEventClass().isInstance(e) || !registeredWebHookEvent.getEventMatcher().matches(e, WebHookListener.fromPersistentStore((Integer)42, (String)"name").to("/").build())) continue;
            return registeredWebHookEvent;
        }
        throw new IllegalStateException("No matching WebHookJiraEvent found for event " + e);
    }
}

