/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.matcher;

import com.atlassian.jira.event.issue.IssueRelatedEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.parser.JqlParseException;
import com.atlassian.jira.jql.parser.JqlQueryParser;
import com.atlassian.jira.plugins.webhooks.validation.JqlValidationUtil;
import com.atlassian.query.Query;
import com.atlassian.webhooks.api.register.listener.WebHookListener;
import com.atlassian.webhooks.spi.EventMatcher;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JqlEventMatcher<T extends IssueRelatedEvent>
implements EventMatcher<T> {
    private final SearchProvider searchProvider;
    private final JqlQueryParser jqlQueryParser;
    private final JqlValidationUtil jqlValidationUtil;
    private static final Logger slowLog = Logger.getLogger((String)(JqlEventMatcher.class.getName() + "_SLOW"));
    private static final Logger log = Logger.getLogger((String)JqlEventMatcher.class.getName());

    @Autowired
    public JqlEventMatcher(SearchProvider searchProvider, JqlQueryParser jqlQueryParser, JqlValidationUtil jqlValidationUtil) {
        this.searchProvider = searchProvider;
        this.jqlQueryParser = jqlQueryParser;
        this.jqlValidationUtil = jqlValidationUtil;
    }

    public boolean matches(T event, WebHookListener listener) {
        return this.matchJql(listener.getParameters().getFilter(), event.getIssue());
    }

    public boolean matchJql(String filter, Issue issue) {
        if (StringUtils.isBlank((String)filter)) {
            return true;
        }
        if (!this.jqlValidationUtil.isJqlValid(filter).isRight()) {
            log.error((Object)String.format("The following JQL query '%-1.800s' defined for filtering webhook events is incorrect. Filtering has been disabled for webhook.", filter));
            return true;
        }
        try {
            Query query = this.getQuery(issue.getKey(), filter);
            long startTime = System.currentTimeMillis();
            boolean matches = this.searchProvider.searchCountOverrideSecurity(query, null) > 0L;
            long queryTime = System.currentTimeMillis() - startTime;
            if (queryTime > 50L) {
                String logMessage = String.format("JQL query '%-1.800s' produced lucene query and took '%d' ms to run.", query.toString(), queryTime);
                slowLog.info((Object)logMessage);
            }
            return matches;
        }
        catch (SearchException e) {
            return false;
        }
        catch (JqlParseException e) {
            log.error((Object)"Query could not be parsed", (Throwable)e);
            return false;
        }
    }

    private Query getQuery(String issueKey, String filter) throws JqlParseException {
        JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder((Query)this.jqlQueryParser.parseQuery(filter));
        return queryBuilder.where().and().issue(new String[]{issueKey}).buildQuery();
    }
}

