/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sourcemap;

import com.atlassian.sourcemap.Base64VLQ;
import com.atlassian.sourcemap.InternalUtil;
import com.atlassian.sourcemap.Mapping;
import com.atlassian.sourcemap.MappingImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class Generator {
    private List<Mapping> mappings = new ArrayList<Mapping>();
    private LinkedHashMap<String, Integer> sourceFileNames = new LinkedHashMap();
    private int nextSourceFileNameIndex = 0;
    private LinkedHashMap<String, Integer> sourceSymbolNames = new LinkedHashMap();
    private int nextSourceSymbolNameIndex = 0;
    private String sourceRootPath;

    Generator() {
    }

    public void addMapping(Mapping mapping) {
        if (mapping.getSourceFileName() != null) {
            if (!this.sourceFileNames.containsKey(mapping.getSourceFileName())) {
                this.sourceFileNames.put(mapping.getSourceFileName(), this.nextSourceFileNameIndex);
                ++this.nextSourceFileNameIndex;
            }
            if (mapping.getSourceSymbolName() != null && !this.sourceSymbolNames.containsKey(mapping.getSourceSymbolName())) {
                this.sourceSymbolNames.put(mapping.getSourceSymbolName(), this.nextSourceSymbolNameIndex);
                ++this.nextSourceSymbolNameIndex;
            }
            this.mappings.add(mapping);
        }
    }

    public void addMapping(int generatedLine, int generatedColumn, int sourceLine, int sourceColumn, String sourceFileName, String sourceSymbolName) {
        this.addMapping(new MappingImpl(generatedLine, generatedColumn, sourceLine, sourceColumn, sourceFileName, sourceSymbolName));
    }

    public void addMapping(int generatedLine, int generatedColumn, int sourceLine, int sourceColumn, String sourceFileName) {
        this.addMapping(generatedLine, generatedColumn, sourceLine, sourceColumn, sourceFileName, null);
    }

    public void generate(Appendable out) {
        try {
            out.append("{\n");
            Generator.appendFirstField(out, "version", "3");
            if (this.sourceRootPath != null && !this.sourceRootPath.isEmpty()) {
                Generator.appendField(out, "sourceRoot", Generator.escapeString(this.sourceRootPath));
            }
            Generator.appendFieldStart(out, "sources");
            out.append("[");
            this.addNameMap(out, this.sourceFileNames);
            out.append("]");
            Generator.appendFieldEnd(out);
            Generator.appendFieldStart(out, "names");
            out.append("[");
            this.addNameMap(out, this.sourceSymbolNames);
            out.append("]");
            Generator.appendFieldEnd(out);
            Generator.appendFieldStart(out, "mappings");
            new LineMapper(out).appendLineMappings();
            Generator.appendFieldEnd(out);
            out.append("\n}");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String generate() {
        StringBuilder out = new StringBuilder();
        this.generate(out);
        return out.toString();
    }

    public void setSourceRoot(String path) {
        this.sourceRootPath = path;
    }

    private void addNameMap(Appendable out, Map<String, Integer> map) throws IOException {
        int i = 0;
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            String key = entry.getKey();
            if (i != 0) {
                out.append(",");
            }
            out.append(Generator.escapeString(key));
            ++i;
        }
    }

    private static String escapeString(String value) {
        return InternalUtil.escapeString(value);
    }

    private static void appendFirstField(Appendable out, String name, CharSequence value) throws IOException {
        out.append("  \"");
        out.append(name);
        out.append("\"");
        out.append(":");
        out.append(value);
    }

    private static void appendField(Appendable out, String name, CharSequence value) throws IOException {
        out.append(",\n");
        out.append("  \"");
        out.append(name);
        out.append("\"");
        out.append(":");
        out.append(value);
    }

    private static void appendFieldStart(Appendable out, String name) throws IOException {
        Generator.appendField(out, name, "");
    }

    private static void appendFieldEnd(Appendable out) throws IOException {
    }

    private int getSourceFileNameIndex(String sourceName) {
        Integer index = this.sourceFileNames.get(sourceName);
        if (index == null) {
            throw new RuntimeException("source file name " + sourceName + " is unknown!");
        }
        return index;
    }

    private int getSourceSymbolNameIndex(String symbolName) {
        Integer index = this.sourceSymbolNames.get(symbolName);
        if (index == null) {
            throw new RuntimeException("source symbol name " + symbolName + " is unknown!");
        }
        return index;
    }

    private class LineMapper {
        private final Appendable out;
        private int previousLine = -1;
        private int previousColumn = 0;
        private int previousSourceFileNameId;
        private int previousSourceLine;
        private int previousSourceColumn;
        private int previousSourceSymbolNameId;

        LineMapper(Appendable out) {
            this.out = out;
        }

        void appendLineMappings() throws IOException {
            this.openLine(true);
            for (Mapping mapping : Generator.this.mappings) {
                int generatedLine = mapping.getGeneratedLine();
                int generatedColumn = mapping.getGeneratedColumn();
                if (generatedLine > 0 && this.previousLine != generatedLine) {
                    int start;
                    for (int i = start = this.previousLine == -1 ? 0 : this.previousLine; i < generatedLine; ++i) {
                        this.closeLine(false);
                        this.openLine(false);
                    }
                }
                if (this.previousLine != generatedLine) {
                    this.previousColumn = 0;
                } else {
                    this.out.append(',');
                }
                this.writeEntry(mapping, generatedColumn);
                this.previousLine = generatedLine;
                this.previousColumn = generatedColumn;
            }
            this.closeLine(true);
        }

        private void openLine(boolean firstEntry) throws IOException {
            if (firstEntry) {
                this.out.append('\"');
            }
        }

        private void closeLine(boolean finalEntry) throws IOException {
            if (!finalEntry) {
                this.out.append(';');
            } else {
                this.out.append('\"');
            }
        }

        void writeEntry(Mapping m, int column) throws IOException {
            Base64VLQ.encode(this.out, column - this.previousColumn);
            this.previousColumn = column;
            if (m != null) {
                int sourceId = Generator.this.getSourceFileNameIndex(m.getSourceFileName());
                Base64VLQ.encode(this.out, sourceId - this.previousSourceFileNameId);
                this.previousSourceFileNameId = sourceId;
                int srcline = m.getSourceLine();
                int srcColumn = m.getSourceColumn();
                Base64VLQ.encode(this.out, srcline - this.previousSourceLine);
                this.previousSourceLine = srcline;
                Base64VLQ.encode(this.out, srcColumn - this.previousSourceColumn);
                this.previousSourceColumn = srcColumn;
                if (m.getSourceSymbolName() != null) {
                    int nameId = Generator.this.getSourceSymbolNameIndex(m.getSourceSymbolName());
                    Base64VLQ.encode(this.out, nameId - this.previousSourceSymbolNameId);
                    this.previousSourceSymbolNameId = nameId;
                }
            }
        }
    }
}

