/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.core;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.JobDetails;
import com.atlassian.util.concurrent.Assertions;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DelegatingSchedulerService
implements SchedulerService {
    private final SchedulerService delegate;

    public DelegatingSchedulerService(SchedulerService delegate) {
        this.delegate = (SchedulerService)Assertions.notNull((String)"delegate", (Object)delegate);
    }

    public void registerJobRunner(JobRunnerKey jobRunnerKey, JobRunner jobRunner) {
        this.delegate.registerJobRunner(jobRunnerKey, jobRunner);
    }

    public void unregisterJobRunner(JobRunnerKey jobRunnerKey) {
        this.delegate.unregisterJobRunner(jobRunnerKey);
    }

    @Nonnull
    public Set<JobRunnerKey> getRegisteredJobRunnerKeys() {
        return this.delegate.getRegisteredJobRunnerKeys();
    }

    @Nonnull
    public Set<JobRunnerKey> getJobRunnerKeysForAllScheduledJobs() {
        return this.delegate.getJobRunnerKeysForAllScheduledJobs();
    }

    public void scheduleJob(JobId jobId, JobConfig jobConfig) throws SchedulerServiceException {
        this.delegate.scheduleJob(jobId, jobConfig);
    }

    @Nonnull
    public JobId scheduleJobWithGeneratedId(JobConfig jobConfig) throws SchedulerServiceException {
        return this.delegate.scheduleJobWithGeneratedId(jobConfig);
    }

    public void unscheduleJob(JobId jobId) {
        this.delegate.unscheduleJob(jobId);
    }

    @Nullable
    public Date calculateNextRunTime(Schedule schedule) throws SchedulerServiceException {
        return this.delegate.calculateNextRunTime(schedule);
    }

    @CheckForNull
    public JobDetails getJobDetails(JobId jobId) {
        return this.delegate.getJobDetails(jobId);
    }

    @Nonnull
    public List<JobDetails> getJobsByJobRunnerKey(JobRunnerKey jobRunnerKey) {
        return this.delegate.getJobsByJobRunnerKey(jobRunnerKey);
    }
}

