/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.directory.internal.impl;

import com.atlassian.gadgets.GadgetParsingException;
import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.directory.Directory;
import com.atlassian.gadgets.directory.internal.DirectoryEntryProvider;
import com.atlassian.gadgets.spec.GadgetSpec;
import com.atlassian.gadgets.spec.GadgetSpecFactory;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Objects;
import java.util.stream.Collectors;

@Scanned
public abstract class AbstractDirectoryEntryProvider<T>
implements DirectoryEntryProvider {
    private final GadgetSpecFactory gadgetSpecFactory;

    public AbstractDirectoryEntryProvider(GadgetSpecFactory gadgetSpecFactory) {
        this.gadgetSpecFactory = gadgetSpecFactory;
    }

    @Override
    public final Iterable<Directory.Entry<?>> entries(GadgetRequestContext gadgetRequestContext, Directory.EntryScope entryScope) {
        ImmutableList internalEntries = ImmutableList.copyOf(this.internalEntries(entryScope));
        return internalEntries.stream().map(internalEntry -> (Directory.OpenSocialDirectoryEntry)this.convertToLocalizedDirectoryEntry(gadgetRequestContext).apply(internalEntry)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected abstract Iterable<T> internalEntries(Directory.EntryScope var1);

    protected abstract Function<T, Directory.OpenSocialDirectoryEntry> convertToLocalizedDirectoryEntry(GadgetRequestContext var1);

    protected final GadgetSpec getGadgetSpec(URI gadgetSpecUri, GadgetRequestContext gadgetRequestContext) throws GadgetParsingException {
        return this.gadgetSpecFactory.getGadgetSpec(gadgetSpecUri, gadgetRequestContext);
    }
}

