/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.quickedit.rest.api.field;

import com.atlassian.jira.issue.fields.rest.json.beans.FieldHtmlBean;
import com.atlassian.jira.quickedit.rest.api.UserPreferences;
import com.atlassian.jira.quickedit.rest.api.field.TabWithLabels;
import com.atlassian.jira.rest.v2.issue.IssueBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.builder.ToStringBuilder;

@XmlRootElement
public class QuickEditFields {
    @XmlElement(name="fields")
    private List<FieldHtmlBean> fields = new ArrayList<FieldHtmlBean>();
    @XmlElement(name="userPreferences")
    private UserPreferences userPreferences;
    @XmlElement(name="sortedTabs")
    private List<TabWithLabels> sortedTabs = new ArrayList<TabWithLabels>();
    @XmlElement(name="issueKey")
    private String issueKey;
    @XmlElement(name="atl_token")
    private String atlToken;
    @XmlElement(name="createdIssueDetails", nillable=true)
    private IssueBean createdIssueDetails;
    @XmlElement(name="formToken")
    private String formToken;

    private QuickEditFields() {
    }

    QuickEditFields(Builder builder) {
        this.atlToken = builder.atlToken;
        this.formToken = builder.formToken;
        this.fields.addAll(builder.fields);
        this.userPreferences = builder.prefs;
        this.sortedTabs.addAll(builder.createSortedTabs());
        this.issueKey = builder.createdIssueKey;
        this.createdIssueDetails = builder.createdIssueDetails;
    }

    public List<FieldHtmlBean> getFields() {
        return this.fields;
    }

    public UserPreferences getUserPreferences() {
        return this.userPreferences;
    }

    public List<TabWithLabels> getSortedTabs() {
        return this.sortedTabs;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("fields", this.fields).append("userPreferences", (Object)this.userPreferences).append("sortedTabs", this.sortedTabs).toString();
    }

    public static class Builder<T extends Builder> {
        private List<FieldHtmlBean> fields = new ArrayList<FieldHtmlBean>();
        private String createdIssueKey;
        private IssueBean createdIssueDetails;
        private UserPreferences prefs;
        private String atlToken;
        private String formToken;

        public T addFields(List<FieldHtmlBean> fields) {
            for (FieldHtmlBean field : fields) {
                this.addField(field);
            }
            return (T)this;
        }

        public T addField(FieldHtmlBean field) {
            this.fields.add(field);
            return (T)this;
        }

        public T createdIssue(String key) {
            this.createdIssueKey = key;
            return (T)this;
        }

        public T createdIssueDetails(IssueBean issueBean) {
            this.createdIssueDetails = issueBean;
            return (T)this;
        }

        public T addUserPreferences(UserPreferences prefs) {
            this.prefs = prefs;
            return (T)this;
        }

        public T addAltToken(String atlToken) {
            this.atlToken = atlToken;
            return (T)this;
        }

        public T addFormToken(String formToken) {
            this.formToken = formToken;
            return (T)this;
        }

        private Collection<TabWithLabels> createSortedTabs() {
            TreeMap<Integer, TabWithLabels> positionToTabMap = new TreeMap<Integer, TabWithLabels>();
            for (FieldHtmlBean field : this.fields) {
                if (field.getTab() == null) continue;
                int position = field.getTab().getPosition();
                if (!positionToTabMap.containsKey(position)) {
                    positionToTabMap.put(position, new TabWithLabels(field.getTab().getLabel()));
                }
                ((TabWithLabels)positionToTabMap.get(position)).add(new TabWithLabels.Field(field.getLabel(), field.getId()));
            }
            return positionToTabMap.values();
        }

        public QuickEditFields build() {
            return new QuickEditFields(this);
        }
    }
}

