/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.quickedit.rest;

import com.atlassian.jira.event.mau.MauApplicationKey;
import com.atlassian.jira.event.mau.MauEventService;
import com.atlassian.jira.quickedit.rest.api.UserPreferences;
import com.atlassian.jira.quickedit.user.UserPreferencesStore;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Path(value="userpreferences")
public class UserPreferenceResource {
    private final JiraAuthenticationContext authenticationContext;
    private final UserPreferencesStore userPreferencesStore;
    private final MauEventService mauEventService;

    public UserPreferenceResource(JiraAuthenticationContext authenticationContext, UserPreferencesStore userPreferencesStore, MauEventService mauEventService) {
        this.authenticationContext = authenticationContext;
        this.userPreferencesStore = userPreferencesStore;
        this.mauEventService = mauEventService;
    }

    @GET
    @Path(value="edit")
    public Response getEditPreferences() {
        ApplicationUser loggedInUser = this.authenticationContext.getLoggedInUser();
        if (loggedInUser == null) {
            return Response.ok((Object)Response.Status.NOT_FOUND).cacheControl(CacheControl.never()).build();
        }
        this.tagRequestAsJiraFamily();
        return Response.ok((Object)this.userPreferencesStore.getEditUserPreferences(loggedInUser)).cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="edit")
    public Response setEditPreferences(UserPreferences prefs) {
        ApplicationUser loggedInUser = this.authenticationContext.getLoggedInUser();
        if (loggedInUser == null || prefs == null) {
            return Response.ok((Object)Response.Status.NOT_FOUND).cacheControl(CacheControl.never()).build();
        }
        this.tagRequestAsJiraFamily();
        this.userPreferencesStore.storeEditUserPreferences(loggedInUser, prefs);
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="create")
    public Response getCreatePreferences() {
        ApplicationUser loggedInUser = this.authenticationContext.getLoggedInUser();
        if (loggedInUser == null) {
            return Response.ok((Object)Response.Status.NOT_FOUND).cacheControl(CacheControl.never()).build();
        }
        this.tagRequestAsJiraFamily();
        return Response.ok((Object)this.userPreferencesStore.getCreateUserPreferences(loggedInUser)).cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="create")
    public Response setCreatePreferences(UserPreferences prefs) {
        ApplicationUser loggedInUser = this.authenticationContext.getLoggedInUser();
        if (loggedInUser == null || prefs == null) {
            return Response.ok((Object)Response.Status.NOT_FOUND).cacheControl(CacheControl.never()).build();
        }
        this.userPreferencesStore.storeCreateUserPreferences(loggedInUser, prefs);
        this.tagRequestAsJiraFamily();
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    private void tagRequestAsJiraFamily() {
        if (this.mauEventService != null) {
            this.mauEventService.setApplicationForThread(MauApplicationKey.family());
        }
    }
}

