/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit.antlr;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CharStream;

public class CSSInputStream
implements CharStream {
    private CharStream input;
    private String rawData;
    private URL base = null;
    private URL url;
    private InputStream source = null;
    private String encoding;

    public static CSSInputStream stringStream(String source) throws IOException {
        CSSInputStream stream = new CSSInputStream();
        stream.rawData = source;
        stream.encoding = Charset.defaultCharset().name();
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(source.getBytes()), stream.encoding));
        stream.input = new ANTLRReaderStream((Reader)br);
        return stream;
    }

    public static CSSInputStream urlStream(URL source, String encoding) throws IOException {
        CSSInputStream stream = new CSSInputStream();
        stream.base = source;
        stream.encoding = encoding != null ? encoding : Charset.defaultCharset().name();
        URLConnection con = source.openConnection();
        InputStream is = "gzip".equalsIgnoreCase(con.getContentEncoding()) ? new GZIPInputStream(con.getInputStream()) : con.getInputStream();
        stream.input = new ANTLRInputStream(is, stream.encoding);
        stream.source = is;
        stream.url = source;
        return stream;
    }

    private CSSInputStream() {
    }

    public int LT(int arg0) {
        return this.input.LT(arg0);
    }

    public int getCharPositionInLine() {
        return this.input.getCharPositionInLine();
    }

    public int getLine() {
        return this.input.getLine();
    }

    public void setCharPositionInLine(int arg0) {
        this.input.setCharPositionInLine(arg0);
    }

    public void setLine(int arg0) {
        this.input.setLine(arg0);
    }

    public String substring(int arg0, int arg1) {
        return this.input.substring(arg0, arg1);
    }

    public int LA(int arg0) {
        return this.input.LA(arg0);
    }

    public void consume() {
        this.input.consume();
    }

    public int index() {
        return this.input.index();
    }

    public int mark() {
        return this.input.mark();
    }

    public void release(int arg0) {
        this.input.release(arg0);
    }

    public void rewind() {
        this.input.rewind();
    }

    public void rewind(int arg0) {
        this.input.rewind(arg0);
    }

    public void seek(int arg0) {
        this.input.seek(arg0);
    }

    public int size() {
        return this.input.size();
    }

    public String getSourceName() {
        return this.base != null ? this.base.toString() : "";
    }

    public URL getBase() {
        return this.base;
    }

    public void setBase(URL base) {
        this.base = base;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String enc) throws IOException {
        if (this.source != null) {
            String current = this.encoding;
            if (current == null) {
                current = Charset.defaultCharset().name();
            }
            if (!current.equalsIgnoreCase(enc)) {
                this.source.close();
                this.encoding = enc;
                CSSInputStream newstream = CSSInputStream.urlStream(this.url, this.encoding);
                this.input = newstream.input;
            }
        }
    }

    public String getRawData() {
        return this.rawData;
    }
}

