/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.streams.common.renderer;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.streams.api.Html;
import com.atlassian.streams.api.StreamsEntry;
import com.atlassian.streams.api.UserProfile;
import com.atlassian.streams.api.common.Functions;
import com.atlassian.streams.api.common.Option;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.Serializable;

final class TitleRenderer
implements Function<StreamsEntry, Html> {
    private final I18nResolver i18nResolver;
    private final String key;
    private final Function<Iterable<UserProfile>, Html> authorsRenderer;
    private final Option<Function<Iterable<StreamsEntry.ActivityObject>, Option<Html>>> activityObjectRenderer;
    private final Option<Function<StreamsEntry.ActivityObject, Option<Html>>> targetRenderer;

    TitleRenderer(I18nResolver i18nResolver, String key, Function<Iterable<UserProfile>, Html> authorsRenderer, Option<Function<Iterable<StreamsEntry.ActivityObject>, Option<Html>>> activityObjectRenderer, Option<Function<StreamsEntry.ActivityObject, Option<Html>>> targetRenderer) {
        this.i18nResolver = i18nResolver;
        this.key = key;
        this.authorsRenderer = authorsRenderer;
        this.activityObjectRenderer = activityObjectRenderer;
        this.targetRenderer = targetRenderer;
    }

    public Html apply(StreamsEntry entry) {
        Option objectHtml = this.activityObjectRenderer.flatMap(this.render(entry.getActivityObjects()));
        Option targetHtml = this.targetRenderer.flatMap(this.render((Option<StreamsEntry.ActivityObject>)entry.getTarget()));
        return new Html(this.getText(this.key, Iterables.concat((Iterable)ImmutableList.of((Object)this.authorsRenderer.apply((Object)entry.getAuthors())), (Iterable)((Iterable)objectHtml.map(Functions.singletonList(Html.class)).getOrElse((Object)ImmutableList.of())), (Iterable)((Iterable)targetHtml.map(Functions.singletonList(Html.class)).getOrElse((Object)ImmutableList.of())))));
    }

    private String getText(String key, Iterable<Html> args) {
        return this.i18nResolver.getText(key, (Serializable[])Iterables.toArray(args, Serializable.class));
    }

    private Function<Function<Iterable<StreamsEntry.ActivityObject>, Option<Html>>, Option<Html>> render(final Iterable<StreamsEntry.ActivityObject> activityObjects) {
        return new Function<Function<Iterable<StreamsEntry.ActivityObject>, Option<Html>>, Option<Html>>(){

            public Option<Html> apply(Function<Iterable<StreamsEntry.ActivityObject>, Option<Html>> renderer) {
                return (Option)renderer.apply((Object)activityObjects);
            }
        };
    }

    private Function<Function<StreamsEntry.ActivityObject, Option<Html>>, Option<Html>> render(final Option<StreamsEntry.ActivityObject> target) {
        return new Function<Function<StreamsEntry.ActivityObject, Option<Html>>, Option<Html>>(){

            public Option<Html> apply(Function<StreamsEntry.ActivityObject, Option<Html>> renderer) {
                return target.flatMap(renderer);
            }
        };
    }
}

