/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.navlink.util.date;

import com.google.common.base.Function;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class UniversalDateFormatter {
    private static final DateTimeFormatter FORMATTER = ISODateTimeFormat.dateTimeNoMillis();

    private UniversalDateFormatter() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    public static String format(DateTime date, DateTimeZone timeZone) {
        return FORMATTER.withZone(timeZone).print((ReadableInstant)date);
    }

    public static String formatUtc(DateTime date) {
        return UniversalDateFormatter.format(date, DateTimeZone.UTC);
    }

    public static DateTime parse(String date) {
        return FORMATTER.parseDateTime(date);
    }

    public static Function<String, DateTime> parseFunction() {
        return new Function<String, DateTime>(){

            public DateTime apply(String from) {
                return UniversalDateFormatter.parse(from);
            }
        };
    }
}

