/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.password.encoder;

import com.atlassian.crowd.password.encoder.InternalPasswordEncoder;
import com.atlassian.crowd.password.encoder.LdapPasswordEncoder;
import com.atlassian.security.utils.ConstantTimeComparison;
import java.util.Locale;
import org.springframework.security.authentication.encoding.Md5PasswordEncoder;

public class LdapMd5PasswordEncoder
extends Md5PasswordEncoder
implements InternalPasswordEncoder,
LdapPasswordEncoder {
    private boolean forceLowerCasePrefix = false;
    protected static final String MD5_PREFIX = "{MD5}";
    protected static final String MD5_PREFIX_LC = "{MD5}".toLowerCase(Locale.ENGLISH);

    public LdapMd5PasswordEncoder() {
        this.setEncodeHashAsBase64(true);
    }

    private final String prefix() {
        return this.forceLowerCasePrefix ? MD5_PREFIX_LC : MD5_PREFIX;
    }

    @Override
    public String encodePassword(String rawPass, Object salt) {
        String encodedPassword = super.encodePassword(rawPass, salt);
        return this.prefix() + encodedPassword;
    }

    @Override
    public boolean isPasswordValid(String encPass, String rawPass, Object salt) {
        String encPassWithoutPrefix = encPass.startsWith(MD5_PREFIX) || encPass.startsWith(MD5_PREFIX_LC) ? encPass.substring(MD5_PREFIX.length()) : encPass;
        return ConstantTimeComparison.isEqual((String)this.encodePassword(rawPass, salt), (String)(this.prefix() + encPassWithoutPrefix));
    }

    @Override
    public String getKey() {
        return "md5";
    }

    public void setForceLowerCasePrefix(boolean forceLowerCasePrefix) {
        this.forceLowerCasePrefix = forceLowerCasePrefix;
    }
}

