/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.link.applinks.rest.resource;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.rest.IssueFinder;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.link.applinks.AppLinkUtils;
import com.atlassian.jira.plugin.link.applinks.rest.bean.AppLinkInfoBean;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.net.Request;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousAllowed
@Path(value="appLink")
public class AppLinksInfoResource {
    private static final Logger LOG = LoggerFactory.getLogger(AppLinksInfoResource.class);
    private final ApplicationLinkService applicationLinkService;
    private final IssueFinder issueFinder;
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;

    public AppLinksInfoResource(@ComponentImport ApplicationLinkService applicationLinkService, @ComponentImport IssueFinder issueFinder, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport PermissionManager permissionManager) {
        this.applicationLinkService = applicationLinkService;
        this.issueFinder = issueFinder;
        this.authenticationContext = authenticationContext;
        this.permissionManager = permissionManager;
    }

    @GET
    @Path(value="/info")
    @Produces(value={"application/json"})
    public Response getAppLinksInfo(@QueryParam(value="type") String type, @QueryParam(value="issueIdOrKey") String issueIdOrKey) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        Issue issue = this.issueFinder.findIssue(issueIdOrKey, (com.atlassian.jira.util.ErrorCollection)errors);
        if (issue == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)errors)).cacheControl(CacheControl.never()).build();
        }
        if (!this.permissionManager.hasPermission(ProjectPermissions.LINK_ISSUES, issue, this.authenticationContext.getUser())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).cacheControl(CacheControl.never()).build();
        }
        Iterable applicationLinks = type != null ? this.getAppLinksByType(type) : this.applicationLinkService.getApplicationLinks();
        Collection<AppLinkInfoBean> beans = this.convertToAppLinkInfoBeans(applicationLinks);
        return Response.ok(beans).cacheControl(CacheControl.never()).build();
    }

    private Iterable<ApplicationLink> getAppLinksByType(String type) {
        try {
            Class<ApplicationType> appTypeClass = AppLinkUtils.getApplicationTypeClass(type);
            return this.applicationLinkService.getApplicationLinks(appTypeClass);
        }
        catch (IllegalArgumentException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private Collection<AppLinkInfoBean> convertToAppLinkInfoBeans(Iterable<ApplicationLink> applicationLinks) {
        ArrayList appLinkInfoBeans = Lists.newArrayList();
        for (ApplicationLink applicationLink : applicationLinks) {
            ApplicationLinkRequestFactory requestFactory = applicationLink.createAuthenticatedRequestFactory();
            boolean requireCredentials = this.appLinksRequiresAuthentication(requestFactory);
            URI authorisationUri = requestFactory.getAuthorisationURI();
            String authUrl = authorisationUri == null ? null : authorisationUri.toString();
            appLinkInfoBeans.add(new AppLinkInfoBean(applicationLink.getId().toString(), applicationLink.getDisplayUrl().toString(), applicationLink.getName(), applicationLink.isPrimary(), authUrl, requireCredentials));
        }
        return appLinkInfoBeans;
    }

    private boolean appLinksRequiresAuthentication(ApplicationLinkRequestFactory requestFactory) {
        try {
            requestFactory.createRequest(Request.MethodType.GET, "");
            return false;
        }
        catch (CredentialsRequiredException e) {
            return true;
        }
    }
}

