/*
 * Decompiled with CFR 0.152.
 */
package com.infomata.data;

import com.infomata.data.DataFormat;
import com.infomata.data.DataRow;

public class SimpleDelimiterFormat
implements DataFormat {
    private char[] delimiter = null;
    private char[] escape = null;

    public SimpleDelimiterFormat(String delimiter, String escape) throws IllegalArgumentException {
        if (delimiter == null || delimiter.length() == 0) {
            throw new IllegalArgumentException("delimter cannot be null or empty.");
        }
        this.delimiter = delimiter.toCharArray();
        this.escape = escape == null ? new char[0] : escape.toCharArray();
    }

    public DataRow parseLine(String line) {
        DataRow row = new DataRow();
        if (line != null && line.length() > 0) {
            StringBuffer o = new StringBuffer();
            char[] ch = line.toCharArray();
            int start = 0;
            boolean ignore = false;
            for (int i = 0; i < ch.length; ++i) {
                if (ch[i] == this.delimiter[0] && this.isDelimiter(ch, i)) {
                    if (ignore) {
                        ignore = false;
                    } else {
                        row.add(this.decodeData(new String(ch, start, i - start)));
                        start = i + this.delimiter.length;
                    }
                    i += this.delimiter.length - 1;
                    continue;
                }
                if (this.escape.length <= 0 || ch[i] != this.escape[0] || !this.isEscape(ch, i)) continue;
                ignore = !ignore;
                i += this.escape.length - 1;
            }
            o.append(new String(ch, start, ch.length - start));
            row.add(o.toString());
        }
        return row;
    }

    public String format(DataRow row) {
        StringBuffer o = new StringBuffer();
        if (row != null && row.size() > 0) {
            o.append(this.encodeData(row.getString(0)));
            for (int i = 1; i < row.size(); ++i) {
                o.append(this.delimiter);
                o.append(this.encodeData(row.getString(i)));
            }
        }
        return o.toString();
    }

    private String decodeData(String content) {
        StringBuffer o = new StringBuffer();
        if (content == null) {
            o.append("null");
        } else if (content.length() > 0) {
            char[] ch = content.toCharArray();
            for (int i = 0; i < ch.length; ++i) {
                if (this.escape.length > 0 && ch[i] == this.escape[0] && this.isEscape(ch, i)) {
                    i += this.escape.length;
                }
                o.append(ch[i]);
            }
        }
        return o.toString();
    }

    private String encodeData(String content) {
        StringBuffer o = new StringBuffer();
        if (content == null) {
            o.append("null");
        } else if (content.length() > 0) {
            char[] ch = content.toCharArray();
            for (int i = 0; i < ch.length; ++i) {
                if (ch[i] == this.delimiter[0] && this.isDelimiter(ch, i) || this.escape.length > 0 && ch[i] == this.escape[0] && this.isEscape(ch, i)) {
                    o.append(this.escape);
                }
                o.append(ch[i]);
            }
        }
        return o.toString();
    }

    private boolean isDelimiter(char[] ch, int offset) {
        return this.match(ch, this.delimiter, offset);
    }

    private boolean isEscape(char[] ch, int offset) {
        return this.match(ch, this.escape, offset);
    }

    private boolean match(char[] ch, char[] sp, int offset) {
        for (int i = 0; i < sp.length && i + offset < ch.length; ++i) {
            if (ch[offset + i] == sp[i]) continue;
            return false;
        }
        return true;
    }
}

