/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.role.confluence;

import com.atlassian.fugue.Option;
import com.atlassian.plugin.Plugin;
import com.atlassian.upm.license.role.confluence.ConfluenceLicensingRole;
import com.atlassian.upm.license.role.confluence.ConfluenceRoleBasedLicenseManager;
import com.atlassian.upm.license.role.spi.LicensingRole;
import com.atlassian.upm.license.role.spi.LicensingRoleCreationFailedException;
import com.atlassian.upm.license.role.spi.RoleBasedLicenseService;
import com.atlassian.user.Group;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.Iterator;

public class ConfluenceRoleBasedLicenseService
implements RoleBasedLicenseService {
    private final ConfluenceRoleBasedLicenseManager manager;

    public ConfluenceRoleBasedLicenseService(ConfluenceRoleBasedLicenseManager manager) {
        this.manager = (ConfluenceRoleBasedLicenseManager)Preconditions.checkNotNull((Object)manager, (Object)"manager");
    }

    public LicensingRole createLicensingRole(Plugin plugin, final String key, String nameI18nKey, String descriptionI18nKey) throws LicensingRoleCreationFailedException {
        LazyReference<Option<Group>> createGroup = new LazyReference<Option<Group>>(){

            protected Option<Group> create() throws Exception {
                return Option.some((Object)ConfluenceRoleBasedLicenseService.this.manager.createGroup(key));
            }
        };
        Option licensingRole = this.manager.getGroup(key).orElse((Supplier)createGroup).map((Function)new Function<Group, LicensingRole>(){

            public LicensingRole apply(Group group) {
                return new ConfluenceLicensingRole(ConfluenceRoleBasedLicenseService.this.manager, group, key);
            }
        });
        Iterator iterator = licensingRole.iterator();
        if (iterator.hasNext()) {
            LicensingRole role = (LicensingRole)iterator.next();
            return role;
        }
        throw new LicensingRoleCreationFailedException("Could not create a group for the licensing role: " + key);
    }

    public LicensingRole getLicensingRole(Plugin plugin, final String key) {
        return (LicensingRole)this.manager.getGroup(key).map((Function)new Function<Group, LicensingRole>(){

            public LicensingRole apply(Group group) {
                return new ConfluenceLicensingRole(ConfluenceRoleBasedLicenseService.this.manager, group, key);
            }
        }).getOrNull();
    }

    public void onPluginUnlicensedEvent(Plugin plugin) {
    }
}

