/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.mapper;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldOption;
import com.atlassian.jira.imports.project.mapper.AbstractMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.MultiValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicApi
public class CustomFieldOptionMapper
extends AbstractMapper {
    private static final Logger log = LoggerFactory.getLogger(CustomFieldOptionMapper.class);
    private final MultiValueMap parentOptionMap = new MultiValueMap();
    private final MultiValueMap childOptionMap = new MultiValueMap();
    private final Map<String, ExternalCustomFieldOption> allOptionMap = new HashMap<String, ExternalCustomFieldOption>();

    public void registerOldValue(ExternalCustomFieldOption customFieldOption) {
        log.debug("Registering CustomField option {} for field {}", (Object)customFieldOption.getId(), (Object)customFieldOption.getCustomFieldId());
        super.registerOldValue(customFieldOption.getId(), customFieldOption.getValue());
        this.allOptionMap.put(customFieldOption.getId(), customFieldOption);
        if (customFieldOption.getParentId() == null) {
            this.parentOptionMap.put((Object)customFieldOption.getFieldConfigId(), (Object)customFieldOption);
        } else {
            this.childOptionMap.put((Object)customFieldOption.getParentId(), (Object)customFieldOption);
        }
    }

    public ExternalCustomFieldOption getCustomFieldOption(String oldId) {
        return this.allOptionMap.get(oldId);
    }

    public Collection getParentOptions(String configurationSchemeId) {
        Collection collection = this.parentOptionMap.getCollection((Object)configurationSchemeId);
        if (collection == null) {
            return Collections.emptyList();
        }
        return collection;
    }

    public Collection getChildOptions(String parentOptionId) {
        Collection collection = this.childOptionMap.getCollection((Object)parentOptionId);
        if (collection == null) {
            return Collections.emptyList();
        }
        return collection;
    }

    @Override
    public void flagValueAsRequired(String oldCustomFieldOptionId) {
        super.flagValueAsRequired(oldCustomFieldOptionId);
    }
}

