/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.onboarding.postsetup.ui;

import com.atlassian.fugue.Option;
import com.atlassian.jira.onboarding.postsetup.PostSetupAnnouncementService;
import com.atlassian.jira.plugin.webresource.JiraWebResourceManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class PostSetupAnnouncementsFilter
implements Filter {
    private final JiraWebResourceManager webResourceManager;
    private final PostSetupAnnouncementService postSetupAnnouncements;
    private final JiraAuthenticationContext authContext;

    @Inject
    public PostSetupAnnouncementsFilter(@ComponentImport JiraWebResourceManager webResourceManager, PostSetupAnnouncementService postSetupAnnouncements, @ComponentImport JiraAuthenticationContext authContext) {
        this.webResourceManager = webResourceManager;
        this.postSetupAnnouncements = postSetupAnnouncements;
        this.authContext = authContext;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Option applicationUser = Option.option((Object)this.authContext.getUser());
        try {
            this.postSetupAnnouncements.recalculateStatuses((Option<ApplicationUser>)applicationUser);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (this.postSetupAnnouncements.hasAnnouncements((Option<ApplicationUser>)applicationUser)) {
            this.webResourceManager.requireResource("com.atlassian.jira.jira-postsetup-announcements-plugin:post-setup-announcements");
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

