/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.onboarding.postsetup.ui;

import com.atlassian.fugue.Option;
import com.atlassian.jira.onboarding.postsetup.PostSetupAnnouncementService;
import com.atlassian.jira.onboarding.postsetup.PostSetupAnnouncementStatus;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;

public class PostSetupAnnouncementDataProvider
implements WebResourceDataProvider {
    private final PostSetupAnnouncementService postSetupAnnouncements;
    private final JiraAuthenticationContext authContext;

    @Inject
    public PostSetupAnnouncementDataProvider(PostSetupAnnouncementService postSetupAnnouncements, @ComponentImport JiraAuthenticationContext authContext) {
        this.postSetupAnnouncements = postSetupAnnouncements;
        this.authContext = authContext;
    }

    public Jsonable get() {
        return new Jsonable(){

            public void write(Writer writer) throws IOException {
                try {
                    PostSetupAnnouncementDataProvider.this.getAnnouncementsData().write(writer);
                }
                catch (JSONException e) {
                    throw new Jsonable.JsonMappingException((Throwable)e);
                }
            }
        };
    }

    public JSONArray getAnnouncementsData() {
        Option applicationUser = Option.option((Object)this.authContext.getUser());
        List activitiesIds = Lists.transform(this.postSetupAnnouncements.getReadyAnnouncements((Option<ApplicationUser>)applicationUser), (Function)new Function<PostSetupAnnouncementStatus, String>(){

            public String apply(PostSetupAnnouncementStatus input) {
                return input.getActivityId();
            }
        });
        return new JSONArray((Collection)activitiesIds);
    }
}

