/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.onboarding.postsetup.checks;

import com.atlassian.jira.mail.settings.MailSettings;
import com.atlassian.jira.onboarding.postsetup.AnnouncementStatusChecker;
import com.atlassian.jira.onboarding.postsetup.PostSetupAnnouncementStatus;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class OutgoingMailSetUpChecker
implements AnnouncementStatusChecker {
    private final MailSettings mailSettings;
    private final MailServerManager mailServerManager;

    @Inject
    public OutgoingMailSetUpChecker(@ComponentImport MailSettings mailSettings, @ComponentImport MailServerManager mailServerManager) {
        this.mailSettings = mailSettings;
        this.mailServerManager = mailServerManager;
    }

    @Override
    public PostSetupAnnouncementStatus.Status computeStatus() {
        if (!this.mailSettings.send().isModifiable()) {
            return PostSetupAnnouncementStatus.Status.AWAITS;
        }
        boolean mailConfiugured = this.mailServerManager.isDefaultSMTPMailServerDefined();
        boolean mailEnabled = this.mailSettings.send().isEnabled();
        if (mailConfiugured && mailEnabled) {
            return PostSetupAnnouncementStatus.Status.FULLFILLED;
        }
        return PostSetupAnnouncementStatus.Status.ANNOUNCE;
    }
}

